/*
 * Decompiled with CFR 0.152.
 */
package com.rivet.api.resources.cloud.common.types;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.rivet.api.core.ObjectMappers;
import java.time.OffsetDateTime;
import java.util.Objects;
import java.util.UUID;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class BuildSummary {
    private final UUID buildId;
    private final UUID uploadId;
    private final String displayName;
    private final OffsetDateTime createTs;
    private final long contentLength;
    private final boolean complete;

    private BuildSummary(UUID buildId, UUID uploadId, String displayName, OffsetDateTime createTs, long contentLength, boolean complete) {
        this.buildId = buildId;
        this.uploadId = uploadId;
        this.displayName = displayName;
        this.createTs = createTs;
        this.contentLength = contentLength;
        this.complete = complete;
    }

    @JsonProperty(value="build_id")
    public UUID getBuildId() {
        return this.buildId;
    }

    @JsonProperty(value="upload_id")
    public UUID getUploadId() {
        return this.uploadId;
    }

    @JsonProperty(value="display_name")
    public String getDisplayName() {
        return this.displayName;
    }

    @JsonProperty(value="create_ts")
    public OffsetDateTime getCreateTs() {
        return this.createTs;
    }

    @JsonProperty(value="content_length")
    public long getContentLength() {
        return this.contentLength;
    }

    @JsonProperty(value="complete")
    public boolean getComplete() {
        return this.complete;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof BuildSummary && this.equalTo((BuildSummary)other);
    }

    private boolean equalTo(BuildSummary other) {
        return this.buildId.equals(other.buildId) && this.uploadId.equals(other.uploadId) && this.displayName.equals(other.displayName) && this.createTs.equals(other.createTs) && this.contentLength == other.contentLength && this.complete == other.complete;
    }

    public int hashCode() {
        return Objects.hash(this.buildId, this.uploadId, this.displayName, this.createTs, this.contentLength, this.complete);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static BuildIdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements BuildIdStage,
    UploadIdStage,
    DisplayNameStage,
    CreateTsStage,
    ContentLengthStage,
    CompleteStage,
    _FinalStage {
        private UUID buildId;
        private UUID uploadId;
        private String displayName;
        private OffsetDateTime createTs;
        private long contentLength;
        private boolean complete;

        private Builder() {
        }

        @Override
        public Builder from(BuildSummary other) {
            this.buildId(other.getBuildId());
            this.uploadId(other.getUploadId());
            this.displayName(other.getDisplayName());
            this.createTs(other.getCreateTs());
            this.contentLength(other.getContentLength());
            this.complete(other.getComplete());
            return this;
        }

        @Override
        @JsonSetter(value="build_id")
        public UploadIdStage buildId(UUID buildId) {
            this.buildId = buildId;
            return this;
        }

        @Override
        @JsonSetter(value="upload_id")
        public DisplayNameStage uploadId(UUID uploadId) {
            this.uploadId = uploadId;
            return this;
        }

        @Override
        @JsonSetter(value="display_name")
        public CreateTsStage displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        @Override
        @JsonSetter(value="create_ts")
        public ContentLengthStage createTs(OffsetDateTime createTs) {
            this.createTs = createTs;
            return this;
        }

        @Override
        @JsonSetter(value="content_length")
        public CompleteStage contentLength(long contentLength) {
            this.contentLength = contentLength;
            return this;
        }

        @Override
        @JsonSetter(value="complete")
        public _FinalStage complete(boolean complete) {
            this.complete = complete;
            return this;
        }

        @Override
        public BuildSummary build() {
            return new BuildSummary(this.buildId, this.uploadId, this.displayName, this.createTs, this.contentLength, this.complete);
        }
    }

    public static interface _FinalStage {
        public BuildSummary build();
    }

    public static interface CompleteStage {
        public _FinalStage complete(boolean var1);
    }

    public static interface ContentLengthStage {
        public CompleteStage contentLength(long var1);
    }

    public static interface CreateTsStage {
        public ContentLengthStage createTs(OffsetDateTime var1);
    }

    public static interface DisplayNameStage {
        public CreateTsStage displayName(String var1);
    }

    public static interface UploadIdStage {
        public DisplayNameStage uploadId(UUID var1);
    }

    public static interface BuildIdStage {
        public UploadIdStage buildId(UUID var1);

        public Builder from(BuildSummary var1);
    }
}

