/*
 * Decompiled with CFR 0.152.
 */
package com.rivet.api.resources.chat.types;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.rivet.api.core.ObjectMappers;
import com.rivet.api.resources.chat.common.types.IdentityTypingStatus;
import com.rivet.api.resources.chat.common.types.Message;
import com.rivet.api.resources.common.types.WatchResponse;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class WatchThreadResponse {
    private final List<Message> chatMessages;
    private final Optional<List<IdentityTypingStatus>> typingStatuses;
    private final WatchResponse watch;

    private WatchThreadResponse(List<Message> chatMessages, Optional<List<IdentityTypingStatus>> typingStatuses, WatchResponse watch) {
        this.chatMessages = chatMessages;
        this.typingStatuses = typingStatuses;
        this.watch = watch;
    }

    @JsonProperty(value="chat_messages")
    public List<Message> getChatMessages() {
        return this.chatMessages;
    }

    @JsonProperty(value="typing_statuses")
    public Optional<List<IdentityTypingStatus>> getTypingStatuses() {
        return this.typingStatuses;
    }

    @JsonProperty(value="watch")
    public WatchResponse getWatch() {
        return this.watch;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof WatchThreadResponse && this.equalTo((WatchThreadResponse)other);
    }

    private boolean equalTo(WatchThreadResponse other) {
        return this.chatMessages.equals(other.chatMessages) && this.typingStatuses.equals(other.typingStatuses) && this.watch.equals(other.watch);
    }

    public int hashCode() {
        return Objects.hash(this.chatMessages, this.typingStatuses, this.watch);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static WatchStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements WatchStage,
    _FinalStage {
        private WatchResponse watch;
        private Optional<List<IdentityTypingStatus>> typingStatuses = Optional.empty();
        private List<Message> chatMessages = new ArrayList<Message>();

        private Builder() {
        }

        @Override
        public Builder from(WatchThreadResponse other) {
            this.chatMessages(other.getChatMessages());
            this.typingStatuses(other.getTypingStatuses());
            this.watch(other.getWatch());
            return this;
        }

        @Override
        @JsonSetter(value="watch")
        public _FinalStage watch(WatchResponse watch) {
            this.watch = watch;
            return this;
        }

        @Override
        public _FinalStage typingStatuses(List<IdentityTypingStatus> typingStatuses) {
            this.typingStatuses = Optional.of(typingStatuses);
            return this;
        }

        @Override
        @JsonSetter(value="typing_statuses", nulls=Nulls.SKIP)
        public _FinalStage typingStatuses(Optional<List<IdentityTypingStatus>> typingStatuses) {
            this.typingStatuses = typingStatuses;
            return this;
        }

        @Override
        public _FinalStage addAllChatMessages(List<Message> chatMessages) {
            this.chatMessages.addAll(chatMessages);
            return this;
        }

        @Override
        public _FinalStage addChatMessages(Message chatMessages) {
            this.chatMessages.add(chatMessages);
            return this;
        }

        @Override
        @JsonSetter(value="chat_messages", nulls=Nulls.SKIP)
        public _FinalStage chatMessages(List<Message> chatMessages) {
            this.chatMessages.clear();
            this.chatMessages.addAll(chatMessages);
            return this;
        }

        @Override
        public WatchThreadResponse build() {
            return new WatchThreadResponse(this.chatMessages, this.typingStatuses, this.watch);
        }
    }

    public static interface _FinalStage {
        public WatchThreadResponse build();

        public _FinalStage chatMessages(List<Message> var1);

        public _FinalStage addChatMessages(Message var1);

        public _FinalStage addAllChatMessages(List<Message> var1);

        public _FinalStage typingStatuses(Optional<List<IdentityTypingStatus>> var1);

        public _FinalStage typingStatuses(List<IdentityTypingStatus> var1);
    }

    public static interface WatchStage {
        public _FinalStage watch(WatchResponse var1);

        public Builder from(WatchThreadResponse var1);
    }
}

