/*
 * Decompiled with CFR 0.152.
 */
package com.rivet.api.resources.chat.types;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.rivet.api.core.ObjectMappers;
import com.rivet.api.resources.chat.common.types.SendMessageBody;
import com.rivet.api.resources.chat.common.types.SendTopic;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class SendMessageRequest {
    private final SendTopic topic;
    private final SendMessageBody messageBody;

    private SendMessageRequest(SendTopic topic, SendMessageBody messageBody) {
        this.topic = topic;
        this.messageBody = messageBody;
    }

    @JsonProperty(value="topic")
    public SendTopic getTopic() {
        return this.topic;
    }

    @JsonProperty(value="message_body")
    public SendMessageBody getMessageBody() {
        return this.messageBody;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof SendMessageRequest && this.equalTo((SendMessageRequest)other);
    }

    private boolean equalTo(SendMessageRequest other) {
        return this.topic.equals(other.topic) && this.messageBody.equals(other.messageBody);
    }

    public int hashCode() {
        return Objects.hash(this.topic, this.messageBody);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static TopicStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements TopicStage,
    MessageBodyStage,
    _FinalStage {
        private SendTopic topic;
        private SendMessageBody messageBody;

        private Builder() {
        }

        @Override
        public Builder from(SendMessageRequest other) {
            this.topic(other.getTopic());
            this.messageBody(other.getMessageBody());
            return this;
        }

        @Override
        @JsonSetter(value="topic")
        public MessageBodyStage topic(SendTopic topic) {
            this.topic = topic;
            return this;
        }

        @Override
        @JsonSetter(value="message_body")
        public _FinalStage messageBody(SendMessageBody messageBody) {
            this.messageBody = messageBody;
            return this;
        }

        @Override
        public SendMessageRequest build() {
            return new SendMessageRequest(this.topic, this.messageBody);
        }
    }

    public static interface _FinalStage {
        public SendMessageRequest build();
    }

    public static interface MessageBodyStage {
        public _FinalStage messageBody(SendMessageBody var1);
    }

    public static interface TopicStage {
        public MessageBodyStage topic(SendTopic var1);

        public Builder from(SendMessageRequest var1);
    }
}

