/*
 * Decompiled with CFR 0.152.
 */
package com.rivet.api.resources.chat.requests;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.rivet.api.core.ObjectMappers;
import com.rivet.api.resources.chat.common.types.QueryDirection;
import java.time.OffsetDateTime;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class GetThreadHistoryRequest {
    private final Optional<OffsetDateTime> ts;
    private final double count;
    private final Optional<QueryDirection> queryDirection;

    private GetThreadHistoryRequest(Optional<OffsetDateTime> ts, double count, Optional<QueryDirection> queryDirection) {
        this.ts = ts;
        this.count = count;
        this.queryDirection = queryDirection;
    }

    @JsonProperty(value="ts")
    public Optional<OffsetDateTime> getTs() {
        return this.ts;
    }

    @JsonProperty(value="count")
    public double getCount() {
        return this.count;
    }

    @JsonProperty(value="query_direction")
    public Optional<QueryDirection> getQueryDirection() {
        return this.queryDirection;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof GetThreadHistoryRequest && this.equalTo((GetThreadHistoryRequest)other);
    }

    private boolean equalTo(GetThreadHistoryRequest other) {
        return this.ts.equals(other.ts) && this.count == other.count && this.queryDirection.equals(other.queryDirection);
    }

    public int hashCode() {
        return Objects.hash(this.ts, this.count, this.queryDirection);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static CountStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements CountStage,
    _FinalStage {
        private double count;
        private Optional<QueryDirection> queryDirection = Optional.empty();
        private Optional<OffsetDateTime> ts = Optional.empty();

        private Builder() {
        }

        @Override
        public Builder from(GetThreadHistoryRequest other) {
            this.ts(other.getTs());
            this.count(other.getCount());
            this.queryDirection(other.getQueryDirection());
            return this;
        }

        @Override
        @JsonSetter(value="count")
        public _FinalStage count(double count) {
            this.count = count;
            return this;
        }

        @Override
        public _FinalStage queryDirection(QueryDirection queryDirection) {
            this.queryDirection = Optional.of(queryDirection);
            return this;
        }

        @Override
        @JsonSetter(value="query_direction", nulls=Nulls.SKIP)
        public _FinalStage queryDirection(Optional<QueryDirection> queryDirection) {
            this.queryDirection = queryDirection;
            return this;
        }

        @Override
        public _FinalStage ts(OffsetDateTime ts) {
            this.ts = Optional.of(ts);
            return this;
        }

        @Override
        @JsonSetter(value="ts", nulls=Nulls.SKIP)
        public _FinalStage ts(Optional<OffsetDateTime> ts) {
            this.ts = ts;
            return this;
        }

        @Override
        public GetThreadHistoryRequest build() {
            return new GetThreadHistoryRequest(this.ts, this.count, this.queryDirection);
        }
    }

    public static interface _FinalStage {
        public GetThreadHistoryRequest build();

        public _FinalStage ts(Optional<OffsetDateTime> var1);

        public _FinalStage ts(OffsetDateTime var1);

        public _FinalStage queryDirection(Optional<QueryDirection> var1);

        public _FinalStage queryDirection(QueryDirection var1);
    }

    public static interface CountStage {
        public _FinalStage count(double var1);

        public Builder from(GetThreadHistoryRequest var1);
    }
}

