/*
 * Decompiled with CFR 0.152.
 */
package com.rivet.api.resources.chat.identity.types;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.rivet.api.core.ObjectMappers;
import com.rivet.api.resources.identity.common.types.Handle;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class GetDirectThreadResponse {
    private final Optional<UUID> threadId;
    private final Optional<Handle> identity;

    private GetDirectThreadResponse(Optional<UUID> threadId, Optional<Handle> identity) {
        this.threadId = threadId;
        this.identity = identity;
    }

    @JsonProperty(value="thread_id")
    public Optional<UUID> getThreadId() {
        return this.threadId;
    }

    @JsonProperty(value="identity")
    public Optional<Handle> getIdentity() {
        return this.identity;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof GetDirectThreadResponse && this.equalTo((GetDirectThreadResponse)other);
    }

    private boolean equalTo(GetDirectThreadResponse other) {
        return this.threadId.equals(other.threadId) && this.identity.equals(other.identity);
    }

    public int hashCode() {
        return Objects.hash(this.threadId, this.identity);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<UUID> threadId = Optional.empty();
        private Optional<Handle> identity = Optional.empty();

        private Builder() {
        }

        public Builder from(GetDirectThreadResponse other) {
            this.threadId(other.getThreadId());
            this.identity(other.getIdentity());
            return this;
        }

        @JsonSetter(value="thread_id", nulls=Nulls.SKIP)
        public Builder threadId(Optional<UUID> threadId) {
            this.threadId = threadId;
            return this;
        }

        public Builder threadId(UUID threadId) {
            this.threadId = Optional.of(threadId);
            return this;
        }

        @JsonSetter(value="identity", nulls=Nulls.SKIP)
        public Builder identity(Optional<Handle> identity) {
            this.identity = identity;
            return this;
        }

        public Builder identity(Handle identity) {
            this.identity = Optional.of(identity);
            return this;
        }

        public GetDirectThreadResponse build() {
            return new GetDirectThreadResponse(this.threadId, this.identity);
        }
    }
}

