/*
 * Decompiled with CFR 0.152.
 */
package com.rivet.api.resources.chat.common.types;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.rivet.api.core.ObjectMappers;
import com.rivet.api.resources.common.types.EmptyObject;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class TypingStatus {
    private final Optional<EmptyObject> idle;
    private final Optional<EmptyObject> typing;

    private TypingStatus(Optional<EmptyObject> idle, Optional<EmptyObject> typing) {
        this.idle = idle;
        this.typing = typing;
    }

    @JsonProperty(value="idle")
    public Optional<EmptyObject> getIdle() {
        return this.idle;
    }

    @JsonProperty(value="typing")
    public Optional<EmptyObject> getTyping() {
        return this.typing;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof TypingStatus && this.equalTo((TypingStatus)other);
    }

    private boolean equalTo(TypingStatus other) {
        return this.idle.equals(other.idle) && this.typing.equals(other.typing);
    }

    public int hashCode() {
        return Objects.hash(this.idle, this.typing);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<EmptyObject> idle = Optional.empty();
        private Optional<EmptyObject> typing = Optional.empty();

        private Builder() {
        }

        public Builder from(TypingStatus other) {
            this.idle(other.getIdle());
            this.typing(other.getTyping());
            return this;
        }

        @JsonSetter(value="idle", nulls=Nulls.SKIP)
        public Builder idle(Optional<EmptyObject> idle) {
            this.idle = idle;
            return this;
        }

        public Builder idle(EmptyObject idle) {
            this.idle = Optional.of(idle);
            return this;
        }

        @JsonSetter(value="typing", nulls=Nulls.SKIP)
        public Builder typing(Optional<EmptyObject> typing) {
            this.typing = typing;
            return this;
        }

        public Builder typing(EmptyObject typing) {
            this.typing = Optional.of(typing);
            return this;
        }

        public TypingStatus build() {
            return new TypingStatus(this.idle, this.typing);
        }
    }
}

