/*
 * Decompiled with CFR 0.152.
 */
package com.rivet.api.resources.chat.common.types;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.rivet.api.core.ObjectMappers;
import com.rivet.api.resources.identity.common.types.Handle;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class TopicDirect {
    private final Handle identityA;
    private final Handle identityB;

    private TopicDirect(Handle identityA, Handle identityB) {
        this.identityA = identityA;
        this.identityB = identityB;
    }

    @JsonProperty(value="identity_a")
    public Handle getIdentityA() {
        return this.identityA;
    }

    @JsonProperty(value="identity_b")
    public Handle getIdentityB() {
        return this.identityB;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof TopicDirect && this.equalTo((TopicDirect)other);
    }

    private boolean equalTo(TopicDirect other) {
        return this.identityA.equals(other.identityA) && this.identityB.equals(other.identityB);
    }

    public int hashCode() {
        return Objects.hash(this.identityA, this.identityB);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static IdentityAStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements IdentityAStage,
    IdentityBStage,
    _FinalStage {
        private Handle identityA;
        private Handle identityB;

        private Builder() {
        }

        @Override
        public Builder from(TopicDirect other) {
            this.identityA(other.getIdentityA());
            this.identityB(other.getIdentityB());
            return this;
        }

        @Override
        @JsonSetter(value="identity_a")
        public IdentityBStage identityA(Handle identityA) {
            this.identityA = identityA;
            return this;
        }

        @Override
        @JsonSetter(value="identity_b")
        public _FinalStage identityB(Handle identityB) {
            this.identityB = identityB;
            return this;
        }

        @Override
        public TopicDirect build() {
            return new TopicDirect(this.identityA, this.identityB);
        }
    }

    public static interface _FinalStage {
        public TopicDirect build();
    }

    public static interface IdentityBStage {
        public _FinalStage identityB(Handle var1);
    }

    public static interface IdentityAStage {
        public IdentityBStage identityA(Handle var1);

        public Builder from(TopicDirect var1);
    }
}

