/*
 * Decompiled with CFR 0.152.
 */
package com.rivet.api.resources.chat.common.types;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.rivet.api.core.ObjectMappers;
import com.rivet.api.resources.chat.common.types.MessageBody;
import java.time.OffsetDateTime;
import java.util.Objects;
import java.util.UUID;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class Message {
    private final UUID chatMessageId;
    private final UUID threadId;
    private final OffsetDateTime sendTs;
    private final MessageBody body;

    private Message(UUID chatMessageId, UUID threadId, OffsetDateTime sendTs, MessageBody body) {
        this.chatMessageId = chatMessageId;
        this.threadId = threadId;
        this.sendTs = sendTs;
        this.body = body;
    }

    @JsonProperty(value="chat_message_id")
    public UUID getChatMessageId() {
        return this.chatMessageId;
    }

    @JsonProperty(value="thread_id")
    public UUID getThreadId() {
        return this.threadId;
    }

    @JsonProperty(value="send_ts")
    public OffsetDateTime getSendTs() {
        return this.sendTs;
    }

    @JsonProperty(value="body")
    public MessageBody getBody() {
        return this.body;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof Message && this.equalTo((Message)other);
    }

    private boolean equalTo(Message other) {
        return this.chatMessageId.equals(other.chatMessageId) && this.threadId.equals(other.threadId) && this.sendTs.equals(other.sendTs) && this.body.equals(other.body);
    }

    public int hashCode() {
        return Objects.hash(this.chatMessageId, this.threadId, this.sendTs, this.body);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static ChatMessageIdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements ChatMessageIdStage,
    ThreadIdStage,
    SendTsStage,
    BodyStage,
    _FinalStage {
        private UUID chatMessageId;
        private UUID threadId;
        private OffsetDateTime sendTs;
        private MessageBody body;

        private Builder() {
        }

        @Override
        public Builder from(Message other) {
            this.chatMessageId(other.getChatMessageId());
            this.threadId(other.getThreadId());
            this.sendTs(other.getSendTs());
            this.body(other.getBody());
            return this;
        }

        @Override
        @JsonSetter(value="chat_message_id")
        public ThreadIdStage chatMessageId(UUID chatMessageId) {
            this.chatMessageId = chatMessageId;
            return this;
        }

        @Override
        @JsonSetter(value="thread_id")
        public SendTsStage threadId(UUID threadId) {
            this.threadId = threadId;
            return this;
        }

        @Override
        @JsonSetter(value="send_ts")
        public BodyStage sendTs(OffsetDateTime sendTs) {
            this.sendTs = sendTs;
            return this;
        }

        @Override
        @JsonSetter(value="body")
        public _FinalStage body(MessageBody body) {
            this.body = body;
            return this;
        }

        @Override
        public Message build() {
            return new Message(this.chatMessageId, this.threadId, this.sendTs, this.body);
        }
    }

    public static interface _FinalStage {
        public Message build();
    }

    public static interface BodyStage {
        public _FinalStage body(MessageBody var1);
    }

    public static interface SendTsStage {
        public BodyStage sendTs(OffsetDateTime var1);
    }

    public static interface ThreadIdStage {
        public SendTsStage threadId(UUID var1);
    }

    public static interface ChatMessageIdStage {
        public ThreadIdStage chatMessageId(UUID var1);

        public Builder from(Message var1);
    }
}

