/*
 * Decompiled with CFR 0.152.
 */
package com.rivet.api.resources.matchmaker.lobbies.types;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.rivet.api.core.ObjectMappers;
import com.rivet.api.resources.matchmaker.common.types.GameModeInfo;
import com.rivet.api.resources.matchmaker.common.types.LobbyInfo;
import com.rivet.api.resources.matchmaker.common.types.RegionInfo;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class ListLobbiesResponse {
    private final List<GameModeInfo> gameModes;
    private final List<RegionInfo> regions;
    private final List<LobbyInfo> lobbies;

    private ListLobbiesResponse(List<GameModeInfo> gameModes, List<RegionInfo> regions, List<LobbyInfo> lobbies) {
        this.gameModes = gameModes;
        this.regions = regions;
        this.lobbies = lobbies;
    }

    @JsonProperty(value="game_modes")
    public List<GameModeInfo> getGameModes() {
        return this.gameModes;
    }

    @JsonProperty(value="regions")
    public List<RegionInfo> getRegions() {
        return this.regions;
    }

    @JsonProperty(value="lobbies")
    public List<LobbyInfo> getLobbies() {
        return this.lobbies;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof ListLobbiesResponse && this.equalTo((ListLobbiesResponse)other);
    }

    private boolean equalTo(ListLobbiesResponse other) {
        return this.gameModes.equals(other.gameModes) && this.regions.equals(other.regions) && this.lobbies.equals(other.lobbies);
    }

    public int hashCode() {
        return Objects.hash(this.gameModes, this.regions, this.lobbies);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private List<GameModeInfo> gameModes = new ArrayList<GameModeInfo>();
        private List<RegionInfo> regions = new ArrayList<RegionInfo>();
        private List<LobbyInfo> lobbies = new ArrayList<LobbyInfo>();

        private Builder() {
        }

        public Builder from(ListLobbiesResponse other) {
            this.gameModes(other.getGameModes());
            this.regions(other.getRegions());
            this.lobbies(other.getLobbies());
            return this;
        }

        @JsonSetter(value="game_modes", nulls=Nulls.SKIP)
        public Builder gameModes(List<GameModeInfo> gameModes) {
            this.gameModes.clear();
            this.gameModes.addAll(gameModes);
            return this;
        }

        public Builder addGameModes(GameModeInfo gameModes) {
            this.gameModes.add(gameModes);
            return this;
        }

        public Builder addAllGameModes(List<GameModeInfo> gameModes) {
            this.gameModes.addAll(gameModes);
            return this;
        }

        @JsonSetter(value="regions", nulls=Nulls.SKIP)
        public Builder regions(List<RegionInfo> regions) {
            this.regions.clear();
            this.regions.addAll(regions);
            return this;
        }

        public Builder addRegions(RegionInfo regions) {
            this.regions.add(regions);
            return this;
        }

        public Builder addAllRegions(List<RegionInfo> regions) {
            this.regions.addAll(regions);
            return this;
        }

        @JsonSetter(value="lobbies", nulls=Nulls.SKIP)
        public Builder lobbies(List<LobbyInfo> lobbies) {
            this.lobbies.clear();
            this.lobbies.addAll(lobbies);
            return this;
        }

        public Builder addLobbies(LobbyInfo lobbies) {
            this.lobbies.add(lobbies);
            return this;
        }

        public Builder addAllLobbies(List<LobbyInfo> lobbies) {
            this.lobbies.addAll(lobbies);
            return this;
        }

        public ListLobbiesResponse build() {
            return new ListLobbiesResponse(this.gameModes, this.regions, this.lobbies);
        }
    }
}

