/*
 * Decompiled with CFR 0.152.
 */
package com.rivet.api.resources.matchmaker.lobbies.requests;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.rivet.api.core.ObjectMappers;
import com.rivet.api.resources.captcha.config.types.Config;
import com.rivet.api.resources.matchmaker.common.types.CustomLobbyPublicity;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class CreateLobbyRequest {
    private final String gameMode;
    private final Optional<String> region;
    private final Optional<Config> captcha;
    private final CustomLobbyPublicity publicity;
    private final Optional<Object> lobbyConfig;
    private final Optional<Object> verificationData;

    private CreateLobbyRequest(String gameMode, Optional<String> region, Optional<Config> captcha, CustomLobbyPublicity publicity, Optional<Object> lobbyConfig, Optional<Object> verificationData) {
        this.gameMode = gameMode;
        this.region = region;
        this.captcha = captcha;
        this.publicity = publicity;
        this.lobbyConfig = lobbyConfig;
        this.verificationData = verificationData;
    }

    @JsonProperty(value="game_mode")
    public String getGameMode() {
        return this.gameMode;
    }

    @JsonProperty(value="region")
    public Optional<String> getRegion() {
        return this.region;
    }

    @JsonProperty(value="captcha")
    public Optional<Config> getCaptcha() {
        return this.captcha;
    }

    @JsonProperty(value="publicity")
    public CustomLobbyPublicity getPublicity() {
        return this.publicity;
    }

    @JsonProperty(value="lobby_config")
    public Optional<Object> getLobbyConfig() {
        return this.lobbyConfig;
    }

    @JsonProperty(value="verification_data")
    public Optional<Object> getVerificationData() {
        return this.verificationData;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof CreateLobbyRequest && this.equalTo((CreateLobbyRequest)other);
    }

    private boolean equalTo(CreateLobbyRequest other) {
        return this.gameMode.equals(other.gameMode) && this.region.equals(other.region) && this.captcha.equals(other.captcha) && this.publicity.equals((Object)other.publicity) && this.lobbyConfig.equals(other.lobbyConfig) && this.verificationData.equals(other.verificationData);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.gameMode, this.region, this.captcha, this.publicity, this.lobbyConfig, this.verificationData});
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static GameModeStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements GameModeStage,
    PublicityStage,
    _FinalStage {
        private String gameMode;
        private CustomLobbyPublicity publicity;
        private Optional<Object> verificationData = Optional.empty();
        private Optional<Object> lobbyConfig = Optional.empty();
        private Optional<Config> captcha = Optional.empty();
        private Optional<String> region = Optional.empty();

        private Builder() {
        }

        @Override
        public Builder from(CreateLobbyRequest other) {
            this.gameMode(other.getGameMode());
            this.region(other.getRegion());
            this.captcha(other.getCaptcha());
            this.publicity(other.getPublicity());
            this.lobbyConfig(other.getLobbyConfig());
            this.verificationData(other.getVerificationData());
            return this;
        }

        @Override
        @JsonSetter(value="game_mode")
        public PublicityStage gameMode(String gameMode) {
            this.gameMode = gameMode;
            return this;
        }

        @Override
        @JsonSetter(value="publicity")
        public _FinalStage publicity(CustomLobbyPublicity publicity) {
            this.publicity = publicity;
            return this;
        }

        @Override
        public _FinalStage verificationData(Object verificationData) {
            this.verificationData = Optional.of(verificationData);
            return this;
        }

        @Override
        @JsonSetter(value="verification_data", nulls=Nulls.SKIP)
        public _FinalStage verificationData(Optional<Object> verificationData) {
            this.verificationData = verificationData;
            return this;
        }

        @Override
        public _FinalStage lobbyConfig(Object lobbyConfig) {
            this.lobbyConfig = Optional.of(lobbyConfig);
            return this;
        }

        @Override
        @JsonSetter(value="lobby_config", nulls=Nulls.SKIP)
        public _FinalStage lobbyConfig(Optional<Object> lobbyConfig) {
            this.lobbyConfig = lobbyConfig;
            return this;
        }

        @Override
        public _FinalStage captcha(Config captcha) {
            this.captcha = Optional.of(captcha);
            return this;
        }

        @Override
        @JsonSetter(value="captcha", nulls=Nulls.SKIP)
        public _FinalStage captcha(Optional<Config> captcha) {
            this.captcha = captcha;
            return this;
        }

        @Override
        public _FinalStage region(String region) {
            this.region = Optional.of(region);
            return this;
        }

        @Override
        @JsonSetter(value="region", nulls=Nulls.SKIP)
        public _FinalStage region(Optional<String> region) {
            this.region = region;
            return this;
        }

        @Override
        public CreateLobbyRequest build() {
            return new CreateLobbyRequest(this.gameMode, this.region, this.captcha, this.publicity, this.lobbyConfig, this.verificationData);
        }
    }

    public static interface _FinalStage {
        public CreateLobbyRequest build();

        public _FinalStage region(Optional<String> var1);

        public _FinalStage region(String var1);

        public _FinalStage captcha(Optional<Config> var1);

        public _FinalStage captcha(Config var1);

        public _FinalStage lobbyConfig(Optional<Object> var1);

        public _FinalStage lobbyConfig(Object var1);

        public _FinalStage verificationData(Optional<Object> var1);

        public _FinalStage verificationData(Object var1);
    }

    public static interface PublicityStage {
        public _FinalStage publicity(CustomLobbyPublicity var1);
    }

    public static interface GameModeStage {
        public PublicityStage gameMode(String var1);

        public Builder from(CreateLobbyRequest var1);
    }
}

