/*
 * Decompiled with CFR 0.152.
 */
package com.rivet.api.resources.matchmaker.common.types;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.rivet.api.core.ObjectMappers;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class LobbyInfo {
    private final String regionId;
    private final String gameModeId;
    private final UUID lobbyId;
    private final int maxPlayersNormal;
    private final int maxPlayersDirect;
    private final int maxPlayersParty;
    private final int totalPlayerCount;
    private final Optional<Object> state;

    private LobbyInfo(String regionId, String gameModeId, UUID lobbyId, int maxPlayersNormal, int maxPlayersDirect, int maxPlayersParty, int totalPlayerCount, Optional<Object> state) {
        this.regionId = regionId;
        this.gameModeId = gameModeId;
        this.lobbyId = lobbyId;
        this.maxPlayersNormal = maxPlayersNormal;
        this.maxPlayersDirect = maxPlayersDirect;
        this.maxPlayersParty = maxPlayersParty;
        this.totalPlayerCount = totalPlayerCount;
        this.state = state;
    }

    @JsonProperty(value="region_id")
    public String getRegionId() {
        return this.regionId;
    }

    @JsonProperty(value="game_mode_id")
    public String getGameModeId() {
        return this.gameModeId;
    }

    @JsonProperty(value="lobby_id")
    public UUID getLobbyId() {
        return this.lobbyId;
    }

    @JsonProperty(value="max_players_normal")
    public int getMaxPlayersNormal() {
        return this.maxPlayersNormal;
    }

    @JsonProperty(value="max_players_direct")
    public int getMaxPlayersDirect() {
        return this.maxPlayersDirect;
    }

    @JsonProperty(value="max_players_party")
    public int getMaxPlayersParty() {
        return this.maxPlayersParty;
    }

    @JsonProperty(value="total_player_count")
    public int getTotalPlayerCount() {
        return this.totalPlayerCount;
    }

    @JsonProperty(value="state")
    public Optional<Object> getState() {
        return this.state;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof LobbyInfo && this.equalTo((LobbyInfo)other);
    }

    private boolean equalTo(LobbyInfo other) {
        return this.regionId.equals(other.regionId) && this.gameModeId.equals(other.gameModeId) && this.lobbyId.equals(other.lobbyId) && this.maxPlayersNormal == other.maxPlayersNormal && this.maxPlayersDirect == other.maxPlayersDirect && this.maxPlayersParty == other.maxPlayersParty && this.totalPlayerCount == other.totalPlayerCount && this.state.equals(other.state);
    }

    public int hashCode() {
        return Objects.hash(this.regionId, this.gameModeId, this.lobbyId, this.maxPlayersNormal, this.maxPlayersDirect, this.maxPlayersParty, this.totalPlayerCount, this.state);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static RegionIdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements RegionIdStage,
    GameModeIdStage,
    LobbyIdStage,
    MaxPlayersNormalStage,
    MaxPlayersDirectStage,
    MaxPlayersPartyStage,
    TotalPlayerCountStage,
    _FinalStage {
        private String regionId;
        private String gameModeId;
        private UUID lobbyId;
        private int maxPlayersNormal;
        private int maxPlayersDirect;
        private int maxPlayersParty;
        private int totalPlayerCount;
        private Optional<Object> state = Optional.empty();

        private Builder() {
        }

        @Override
        public Builder from(LobbyInfo other) {
            this.regionId(other.getRegionId());
            this.gameModeId(other.getGameModeId());
            this.lobbyId(other.getLobbyId());
            this.maxPlayersNormal(other.getMaxPlayersNormal());
            this.maxPlayersDirect(other.getMaxPlayersDirect());
            this.maxPlayersParty(other.getMaxPlayersParty());
            this.totalPlayerCount(other.getTotalPlayerCount());
            this.state(other.getState());
            return this;
        }

        @Override
        @JsonSetter(value="region_id")
        public GameModeIdStage regionId(String regionId) {
            this.regionId = regionId;
            return this;
        }

        @Override
        @JsonSetter(value="game_mode_id")
        public LobbyIdStage gameModeId(String gameModeId) {
            this.gameModeId = gameModeId;
            return this;
        }

        @Override
        @JsonSetter(value="lobby_id")
        public MaxPlayersNormalStage lobbyId(UUID lobbyId) {
            this.lobbyId = lobbyId;
            return this;
        }

        @Override
        @JsonSetter(value="max_players_normal")
        public MaxPlayersDirectStage maxPlayersNormal(int maxPlayersNormal) {
            this.maxPlayersNormal = maxPlayersNormal;
            return this;
        }

        @Override
        @JsonSetter(value="max_players_direct")
        public MaxPlayersPartyStage maxPlayersDirect(int maxPlayersDirect) {
            this.maxPlayersDirect = maxPlayersDirect;
            return this;
        }

        @Override
        @JsonSetter(value="max_players_party")
        public TotalPlayerCountStage maxPlayersParty(int maxPlayersParty) {
            this.maxPlayersParty = maxPlayersParty;
            return this;
        }

        @Override
        @JsonSetter(value="total_player_count")
        public _FinalStage totalPlayerCount(int totalPlayerCount) {
            this.totalPlayerCount = totalPlayerCount;
            return this;
        }

        @Override
        public _FinalStage state(Object state) {
            this.state = Optional.of(state);
            return this;
        }

        @Override
        @JsonSetter(value="state", nulls=Nulls.SKIP)
        public _FinalStage state(Optional<Object> state) {
            this.state = state;
            return this;
        }

        @Override
        public LobbyInfo build() {
            return new LobbyInfo(this.regionId, this.gameModeId, this.lobbyId, this.maxPlayersNormal, this.maxPlayersDirect, this.maxPlayersParty, this.totalPlayerCount, this.state);
        }
    }

    public static interface _FinalStage {
        public LobbyInfo build();

        public _FinalStage state(Optional<Object> var1);

        public _FinalStage state(Object var1);
    }

    public static interface TotalPlayerCountStage {
        public _FinalStage totalPlayerCount(int var1);
    }

    public static interface MaxPlayersPartyStage {
        public TotalPlayerCountStage maxPlayersParty(int var1);
    }

    public static interface MaxPlayersDirectStage {
        public MaxPlayersPartyStage maxPlayersDirect(int var1);
    }

    public static interface MaxPlayersNormalStage {
        public MaxPlayersDirectStage maxPlayersNormal(int var1);
    }

    public static interface LobbyIdStage {
        public MaxPlayersNormalStage lobbyId(UUID var1);
    }

    public static interface GameModeIdStage {
        public LobbyIdStage gameModeId(String var1);
    }

    public static interface RegionIdStage {
        public GameModeIdStage regionId(String var1);

        public Builder from(LobbyInfo var1);
    }
}

