/*
 * Decompiled with CFR 0.152.
 */
package com.rivet.api.resources.identity.types;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.rivet.api.core.ObjectMappers;
import com.rivet.api.resources.common.types.WatchResponse;
import com.rivet.api.resources.identity.common.types.Profile;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class GetProfileResponse {
    private final Profile identity;
    private final WatchResponse watch;

    private GetProfileResponse(Profile identity, WatchResponse watch) {
        this.identity = identity;
        this.watch = watch;
    }

    @JsonProperty(value="identity")
    public Profile getIdentity() {
        return this.identity;
    }

    @JsonProperty(value="watch")
    public WatchResponse getWatch() {
        return this.watch;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof GetProfileResponse && this.equalTo((GetProfileResponse)other);
    }

    private boolean equalTo(GetProfileResponse other) {
        return this.identity.equals(other.identity) && this.watch.equals(other.watch);
    }

    public int hashCode() {
        return Objects.hash(this.identity, this.watch);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static IdentityStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements IdentityStage,
    WatchStage,
    _FinalStage {
        private Profile identity;
        private WatchResponse watch;

        private Builder() {
        }

        @Override
        public Builder from(GetProfileResponse other) {
            this.identity(other.getIdentity());
            this.watch(other.getWatch());
            return this;
        }

        @Override
        @JsonSetter(value="identity")
        public WatchStage identity(Profile identity) {
            this.identity = identity;
            return this;
        }

        @Override
        @JsonSetter(value="watch")
        public _FinalStage watch(WatchResponse watch) {
            this.watch = watch;
            return this;
        }

        @Override
        public GetProfileResponse build() {
            return new GetProfileResponse(this.identity, this.watch);
        }
    }

    public static interface _FinalStage {
        public GetProfileResponse build();
    }

    public static interface WatchStage {
        public _FinalStage watch(WatchResponse var1);
    }

    public static interface IdentityStage {
        public WatchStage identity(Profile var1);

        public Builder from(GetProfileResponse var1);
    }
}

