/*
 * Decompiled with CFR 0.152.
 */
package com.rivet.api.resources.group.types;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.rivet.api.core.ObjectMappers;
import com.rivet.api.resources.common.types.WatchResponse;
import com.rivet.api.resources.group.common.types.Summary;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class ListSuggestedResponse {
    private final List<Summary> groups;
    private final WatchResponse watch;

    private ListSuggestedResponse(List<Summary> groups, WatchResponse watch) {
        this.groups = groups;
        this.watch = watch;
    }

    @JsonProperty(value="groups")
    public List<Summary> getGroups() {
        return this.groups;
    }

    @JsonProperty(value="watch")
    public WatchResponse getWatch() {
        return this.watch;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof ListSuggestedResponse && this.equalTo((ListSuggestedResponse)other);
    }

    private boolean equalTo(ListSuggestedResponse other) {
        return this.groups.equals(other.groups) && this.watch.equals(other.watch);
    }

    public int hashCode() {
        return Objects.hash(this.groups, this.watch);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static WatchStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements WatchStage,
    _FinalStage {
        private WatchResponse watch;
        private List<Summary> groups = new ArrayList<Summary>();

        private Builder() {
        }

        @Override
        public Builder from(ListSuggestedResponse other) {
            this.groups(other.getGroups());
            this.watch(other.getWatch());
            return this;
        }

        @Override
        @JsonSetter(value="watch")
        public _FinalStage watch(WatchResponse watch) {
            this.watch = watch;
            return this;
        }

        @Override
        public _FinalStage addAllGroups(List<Summary> groups) {
            this.groups.addAll(groups);
            return this;
        }

        @Override
        public _FinalStage addGroups(Summary groups) {
            this.groups.add(groups);
            return this;
        }

        @Override
        @JsonSetter(value="groups", nulls=Nulls.SKIP)
        public _FinalStage groups(List<Summary> groups) {
            this.groups.clear();
            this.groups.addAll(groups);
            return this;
        }

        @Override
        public ListSuggestedResponse build() {
            return new ListSuggestedResponse(this.groups, this.watch);
        }
    }

    public static interface _FinalStage {
        public ListSuggestedResponse build();

        public _FinalStage groups(List<Summary> var1);

        public _FinalStage addGroups(Summary var1);

        public _FinalStage addAllGroups(List<Summary> var1);
    }

    public static interface WatchStage {
        public _FinalStage watch(WatchResponse var1);

        public Builder from(ListSuggestedResponse var1);
    }
}

