/*
 * Decompiled with CFR 0.152.
 */
package com.rivet.api.resources.group.types;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.rivet.api.core.ObjectMappers;
import com.rivet.api.resources.common.types.WatchResponse;
import com.rivet.api.resources.group.common.types.Member;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class GetMembersResponse {
    private final List<Member> members;
    private final Optional<String> anchor;
    private final WatchResponse watch;

    private GetMembersResponse(List<Member> members, Optional<String> anchor, WatchResponse watch) {
        this.members = members;
        this.anchor = anchor;
        this.watch = watch;
    }

    @JsonProperty(value="members")
    public List<Member> getMembers() {
        return this.members;
    }

    @JsonProperty(value="anchor")
    public Optional<String> getAnchor() {
        return this.anchor;
    }

    @JsonProperty(value="watch")
    public WatchResponse getWatch() {
        return this.watch;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof GetMembersResponse && this.equalTo((GetMembersResponse)other);
    }

    private boolean equalTo(GetMembersResponse other) {
        return this.members.equals(other.members) && this.anchor.equals(other.anchor) && this.watch.equals(other.watch);
    }

    public int hashCode() {
        return Objects.hash(this.members, this.anchor, this.watch);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static WatchStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements WatchStage,
    _FinalStage {
        private WatchResponse watch;
        private Optional<String> anchor = Optional.empty();
        private List<Member> members = new ArrayList<Member>();

        private Builder() {
        }

        @Override
        public Builder from(GetMembersResponse other) {
            this.members(other.getMembers());
            this.anchor(other.getAnchor());
            this.watch(other.getWatch());
            return this;
        }

        @Override
        @JsonSetter(value="watch")
        public _FinalStage watch(WatchResponse watch) {
            this.watch = watch;
            return this;
        }

        @Override
        public _FinalStage anchor(String anchor) {
            this.anchor = Optional.of(anchor);
            return this;
        }

        @Override
        @JsonSetter(value="anchor", nulls=Nulls.SKIP)
        public _FinalStage anchor(Optional<String> anchor) {
            this.anchor = anchor;
            return this;
        }

        @Override
        public _FinalStage addAllMembers(List<Member> members) {
            this.members.addAll(members);
            return this;
        }

        @Override
        public _FinalStage addMembers(Member members) {
            this.members.add(members);
            return this;
        }

        @Override
        @JsonSetter(value="members", nulls=Nulls.SKIP)
        public _FinalStage members(List<Member> members) {
            this.members.clear();
            this.members.addAll(members);
            return this;
        }

        @Override
        public GetMembersResponse build() {
            return new GetMembersResponse(this.members, this.anchor, this.watch);
        }
    }

    public static interface _FinalStage {
        public GetMembersResponse build();

        public _FinalStage members(List<Member> var1);

        public _FinalStage addMembers(Member var1);

        public _FinalStage addAllMembers(List<Member> var1);

        public _FinalStage anchor(Optional<String> var1);

        public _FinalStage anchor(String var1);
    }

    public static interface WatchStage {
        public _FinalStage watch(WatchResponse var1);

        public Builder from(GetMembersResponse var1);
    }
}

