/*
 * Decompiled with CFR 0.152.
 */
package com.rivet.api.resources.geo.common.types;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.rivet.api.core.ObjectMappers;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class Distance {
    private final double kilometers;
    private final double miles;

    private Distance(double kilometers, double miles) {
        this.kilometers = kilometers;
        this.miles = miles;
    }

    @JsonProperty(value="kilometers")
    public double getKilometers() {
        return this.kilometers;
    }

    @JsonProperty(value="miles")
    public double getMiles() {
        return this.miles;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof Distance && this.equalTo((Distance)other);
    }

    private boolean equalTo(Distance other) {
        return this.kilometers == other.kilometers && this.miles == other.miles;
    }

    public int hashCode() {
        return Objects.hash(this.kilometers, this.miles);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static KilometersStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements KilometersStage,
    MilesStage,
    _FinalStage {
        private double kilometers;
        private double miles;

        private Builder() {
        }

        @Override
        public Builder from(Distance other) {
            this.kilometers(other.getKilometers());
            this.miles(other.getMiles());
            return this;
        }

        @Override
        @JsonSetter(value="kilometers")
        public MilesStage kilometers(double kilometers) {
            this.kilometers = kilometers;
            return this;
        }

        @Override
        @JsonSetter(value="miles")
        public _FinalStage miles(double miles) {
            this.miles = miles;
            return this;
        }

        @Override
        public Distance build() {
            return new Distance(this.kilometers, this.miles);
        }
    }

    public static interface _FinalStage {
        public Distance build();
    }

    public static interface MilesStage {
        public _FinalStage miles(double var1);
    }

    public static interface KilometersStage {
        public MilesStage kilometers(double var1);

        public Builder from(Distance var1);
    }
}

