/*
 * Decompiled with CFR 0.152.
 */
package com.rivet.api.resources.game.common.types;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.rivet.api.core.ObjectMappers;
import com.rivet.api.resources.game.common.types.StatAggregationMethod;
import com.rivet.api.resources.game.common.types.StatFormatMethod;
import com.rivet.api.resources.game.common.types.StatSortingMethod;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class StatConfig {
    private final UUID recordId;
    private final UUID iconId;
    private final StatFormatMethod format;
    private final StatAggregationMethod aggregation;
    private final StatSortingMethod sorting;
    private final int priority;
    private final String displayName;
    private final Optional<String> postfixSingular;
    private final Optional<String> postfixPlural;
    private final Optional<String> prefixSingular;
    private final Optional<String> prefixPlural;

    private StatConfig(UUID recordId, UUID iconId, StatFormatMethod format, StatAggregationMethod aggregation, StatSortingMethod sorting, int priority, String displayName, Optional<String> postfixSingular, Optional<String> postfixPlural, Optional<String> prefixSingular, Optional<String> prefixPlural) {
        this.recordId = recordId;
        this.iconId = iconId;
        this.format = format;
        this.aggregation = aggregation;
        this.sorting = sorting;
        this.priority = priority;
        this.displayName = displayName;
        this.postfixSingular = postfixSingular;
        this.postfixPlural = postfixPlural;
        this.prefixSingular = prefixSingular;
        this.prefixPlural = prefixPlural;
    }

    @JsonProperty(value="record_id")
    public UUID getRecordId() {
        return this.recordId;
    }

    @JsonProperty(value="icon_id")
    public UUID getIconId() {
        return this.iconId;
    }

    @JsonProperty(value="format")
    public StatFormatMethod getFormat() {
        return this.format;
    }

    @JsonProperty(value="aggregation")
    public StatAggregationMethod getAggregation() {
        return this.aggregation;
    }

    @JsonProperty(value="sorting")
    public StatSortingMethod getSorting() {
        return this.sorting;
    }

    @JsonProperty(value="priority")
    public int getPriority() {
        return this.priority;
    }

    @JsonProperty(value="display_name")
    public String getDisplayName() {
        return this.displayName;
    }

    @JsonProperty(value="postfix_singular")
    public Optional<String> getPostfixSingular() {
        return this.postfixSingular;
    }

    @JsonProperty(value="postfix_plural")
    public Optional<String> getPostfixPlural() {
        return this.postfixPlural;
    }

    @JsonProperty(value="prefix_singular")
    public Optional<String> getPrefixSingular() {
        return this.prefixSingular;
    }

    @JsonProperty(value="prefix_plural")
    public Optional<String> getPrefixPlural() {
        return this.prefixPlural;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof StatConfig && this.equalTo((StatConfig)other);
    }

    private boolean equalTo(StatConfig other) {
        return this.recordId.equals(other.recordId) && this.iconId.equals(other.iconId) && this.format.equals((Object)other.format) && this.aggregation.equals((Object)other.aggregation) && this.sorting.equals((Object)other.sorting) && this.priority == other.priority && this.displayName.equals(other.displayName) && this.postfixSingular.equals(other.postfixSingular) && this.postfixPlural.equals(other.postfixPlural) && this.prefixSingular.equals(other.prefixSingular) && this.prefixPlural.equals(other.prefixPlural);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.recordId, this.iconId, this.format, this.aggregation, this.sorting, this.priority, this.displayName, this.postfixSingular, this.postfixPlural, this.prefixSingular, this.prefixPlural});
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static RecordIdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements RecordIdStage,
    IconIdStage,
    FormatStage,
    AggregationStage,
    SortingStage,
    PriorityStage,
    DisplayNameStage,
    _FinalStage {
        private UUID recordId;
        private UUID iconId;
        private StatFormatMethod format;
        private StatAggregationMethod aggregation;
        private StatSortingMethod sorting;
        private int priority;
        private String displayName;
        private Optional<String> prefixPlural = Optional.empty();
        private Optional<String> prefixSingular = Optional.empty();
        private Optional<String> postfixPlural = Optional.empty();
        private Optional<String> postfixSingular = Optional.empty();

        private Builder() {
        }

        @Override
        public Builder from(StatConfig other) {
            this.recordId(other.getRecordId());
            this.iconId(other.getIconId());
            this.format(other.getFormat());
            this.aggregation(other.getAggregation());
            this.sorting(other.getSorting());
            this.priority(other.getPriority());
            this.displayName(other.getDisplayName());
            this.postfixSingular(other.getPostfixSingular());
            this.postfixPlural(other.getPostfixPlural());
            this.prefixSingular(other.getPrefixSingular());
            this.prefixPlural(other.getPrefixPlural());
            return this;
        }

        @Override
        @JsonSetter(value="record_id")
        public IconIdStage recordId(UUID recordId) {
            this.recordId = recordId;
            return this;
        }

        @Override
        @JsonSetter(value="icon_id")
        public FormatStage iconId(UUID iconId) {
            this.iconId = iconId;
            return this;
        }

        @Override
        @JsonSetter(value="format")
        public AggregationStage format(StatFormatMethod format) {
            this.format = format;
            return this;
        }

        @Override
        @JsonSetter(value="aggregation")
        public SortingStage aggregation(StatAggregationMethod aggregation) {
            this.aggregation = aggregation;
            return this;
        }

        @Override
        @JsonSetter(value="sorting")
        public PriorityStage sorting(StatSortingMethod sorting) {
            this.sorting = sorting;
            return this;
        }

        @Override
        @JsonSetter(value="priority")
        public DisplayNameStage priority(int priority) {
            this.priority = priority;
            return this;
        }

        @Override
        @JsonSetter(value="display_name")
        public _FinalStage displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        @Override
        public _FinalStage prefixPlural(String prefixPlural) {
            this.prefixPlural = Optional.of(prefixPlural);
            return this;
        }

        @Override
        @JsonSetter(value="prefix_plural", nulls=Nulls.SKIP)
        public _FinalStage prefixPlural(Optional<String> prefixPlural) {
            this.prefixPlural = prefixPlural;
            return this;
        }

        @Override
        public _FinalStage prefixSingular(String prefixSingular) {
            this.prefixSingular = Optional.of(prefixSingular);
            return this;
        }

        @Override
        @JsonSetter(value="prefix_singular", nulls=Nulls.SKIP)
        public _FinalStage prefixSingular(Optional<String> prefixSingular) {
            this.prefixSingular = prefixSingular;
            return this;
        }

        @Override
        public _FinalStage postfixPlural(String postfixPlural) {
            this.postfixPlural = Optional.of(postfixPlural);
            return this;
        }

        @Override
        @JsonSetter(value="postfix_plural", nulls=Nulls.SKIP)
        public _FinalStage postfixPlural(Optional<String> postfixPlural) {
            this.postfixPlural = postfixPlural;
            return this;
        }

        @Override
        public _FinalStage postfixSingular(String postfixSingular) {
            this.postfixSingular = Optional.of(postfixSingular);
            return this;
        }

        @Override
        @JsonSetter(value="postfix_singular", nulls=Nulls.SKIP)
        public _FinalStage postfixSingular(Optional<String> postfixSingular) {
            this.postfixSingular = postfixSingular;
            return this;
        }

        @Override
        public StatConfig build() {
            return new StatConfig(this.recordId, this.iconId, this.format, this.aggregation, this.sorting, this.priority, this.displayName, this.postfixSingular, this.postfixPlural, this.prefixSingular, this.prefixPlural);
        }
    }

    public static interface _FinalStage {
        public StatConfig build();

        public _FinalStage postfixSingular(Optional<String> var1);

        public _FinalStage postfixSingular(String var1);

        public _FinalStage postfixPlural(Optional<String> var1);

        public _FinalStage postfixPlural(String var1);

        public _FinalStage prefixSingular(Optional<String> var1);

        public _FinalStage prefixSingular(String var1);

        public _FinalStage prefixPlural(Optional<String> var1);

        public _FinalStage prefixPlural(String var1);
    }

    public static interface DisplayNameStage {
        public _FinalStage displayName(String var1);
    }

    public static interface PriorityStage {
        public DisplayNameStage priority(int var1);
    }

    public static interface SortingStage {
        public PriorityStage sorting(StatSortingMethod var1);
    }

    public static interface AggregationStage {
        public SortingStage aggregation(StatAggregationMethod var1);
    }

    public static interface FormatStage {
        public AggregationStage format(StatFormatMethod var1);
    }

    public static interface IconIdStage {
        public FormatStage iconId(UUID var1);
    }

    public static interface RecordIdStage {
        public IconIdStage recordId(UUID var1);

        public Builder from(StatConfig var1);
    }
}

