/*
 * Decompiled with CFR 0.152.
 */
package com.rivet.api.resources.cloud.version.matchmaker.gamemode.types;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.rivet.api.core.ObjectMappers;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class GameModeVerificationConfig {
    private final String url;
    private final Map<String, String> headers;

    private GameModeVerificationConfig(String url, Map<String, String> headers) {
        this.url = url;
        this.headers = headers;
    }

    @JsonProperty(value="url")
    public String getUrl() {
        return this.url;
    }

    @JsonProperty(value="headers")
    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof GameModeVerificationConfig && this.equalTo((GameModeVerificationConfig)other);
    }

    private boolean equalTo(GameModeVerificationConfig other) {
        return this.url.equals(other.url) && this.headers.equals(other.headers);
    }

    public int hashCode() {
        return Objects.hash(this.url, this.headers);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static UrlStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements UrlStage,
    _FinalStage {
        private String url;
        private Map<String, String> headers = new LinkedHashMap<String, String>();

        private Builder() {
        }

        @Override
        public Builder from(GameModeVerificationConfig other) {
            this.url(other.getUrl());
            this.headers(other.getHeaders());
            return this;
        }

        @Override
        @JsonSetter(value="url")
        public _FinalStage url(String url) {
            this.url = url;
            return this;
        }

        @Override
        public _FinalStage headers(String key, String value) {
            this.headers.put(key, value);
            return this;
        }

        @Override
        public _FinalStage putAllHeaders(Map<String, String> headers) {
            this.headers.putAll(headers);
            return this;
        }

        @Override
        @JsonSetter(value="headers", nulls=Nulls.SKIP)
        public _FinalStage headers(Map<String, String> headers) {
            this.headers.clear();
            this.headers.putAll(headers);
            return this;
        }

        @Override
        public GameModeVerificationConfig build() {
            return new GameModeVerificationConfig(this.url, this.headers);
        }
    }

    public static interface _FinalStage {
        public GameModeVerificationConfig build();

        public _FinalStage headers(Map<String, String> var1);

        public _FinalStage putAllHeaders(Map<String, String> var1);

        public _FinalStage headers(String var1, String var2);
    }

    public static interface UrlStage {
        public _FinalStage url(String var1);

        public Builder from(GameModeVerificationConfig var1);
    }
}

