/*
 * Decompiled with CFR 0.152.
 */
package com.rivet.api.resources.cloud.games.games.types;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.rivet.api.core.ObjectMappers;
import com.rivet.api.resources.cloud.common.types.GameFull;
import com.rivet.api.resources.common.types.WatchResponse;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class GetGameByIdResponse {
    private final GameFull game;
    private final WatchResponse watch;

    private GetGameByIdResponse(GameFull game, WatchResponse watch) {
        this.game = game;
        this.watch = watch;
    }

    @JsonProperty(value="game")
    public GameFull getGame() {
        return this.game;
    }

    @JsonProperty(value="watch")
    public WatchResponse getWatch() {
        return this.watch;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof GetGameByIdResponse && this.equalTo((GetGameByIdResponse)other);
    }

    private boolean equalTo(GetGameByIdResponse other) {
        return this.game.equals(other.game) && this.watch.equals(other.watch);
    }

    public int hashCode() {
        return Objects.hash(this.game, this.watch);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static GameStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements GameStage,
    WatchStage,
    _FinalStage {
        private GameFull game;
        private WatchResponse watch;

        private Builder() {
        }

        @Override
        public Builder from(GetGameByIdResponse other) {
            this.game(other.getGame());
            this.watch(other.getWatch());
            return this;
        }

        @Override
        @JsonSetter(value="game")
        public WatchStage game(GameFull game) {
            this.game = game;
            return this;
        }

        @Override
        @JsonSetter(value="watch")
        public _FinalStage watch(WatchResponse watch) {
            this.watch = watch;
            return this;
        }

        @Override
        public GetGameByIdResponse build() {
            return new GetGameByIdResponse(this.game, this.watch);
        }
    }

    public static interface _FinalStage {
        public GetGameByIdResponse build();
    }

    public static interface WatchStage {
        public _FinalStage watch(WatchResponse var1);
    }

    public static interface GameStage {
        public WatchStage game(GameFull var1);

        public Builder from(GetGameByIdResponse var1);
    }
}

