/*
 * Decompiled with CFR 0.152.
 */
package com.rivet.api.resources.cloud.games.cdn.types;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.rivet.api.core.ObjectMappers;
import com.rivet.api.resources.upload.common.types.PrepareFile;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class CreateGameCdnSiteRequest {
    private final String displayName;
    private final List<PrepareFile> files;

    private CreateGameCdnSiteRequest(String displayName, List<PrepareFile> files) {
        this.displayName = displayName;
        this.files = files;
    }

    @JsonProperty(value="display_name")
    public String getDisplayName() {
        return this.displayName;
    }

    @JsonProperty(value="files")
    public List<PrepareFile> getFiles() {
        return this.files;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof CreateGameCdnSiteRequest && this.equalTo((CreateGameCdnSiteRequest)other);
    }

    private boolean equalTo(CreateGameCdnSiteRequest other) {
        return this.displayName.equals(other.displayName) && this.files.equals(other.files);
    }

    public int hashCode() {
        return Objects.hash(this.displayName, this.files);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static DisplayNameStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements DisplayNameStage,
    _FinalStage {
        private String displayName;
        private List<PrepareFile> files = new ArrayList<PrepareFile>();

        private Builder() {
        }

        @Override
        public Builder from(CreateGameCdnSiteRequest other) {
            this.displayName(other.getDisplayName());
            this.files(other.getFiles());
            return this;
        }

        @Override
        @JsonSetter(value="display_name")
        public _FinalStage displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        @Override
        public _FinalStage addAllFiles(List<PrepareFile> files) {
            this.files.addAll(files);
            return this;
        }

        @Override
        public _FinalStage addFiles(PrepareFile files) {
            this.files.add(files);
            return this;
        }

        @Override
        @JsonSetter(value="files", nulls=Nulls.SKIP)
        public _FinalStage files(List<PrepareFile> files) {
            this.files.clear();
            this.files.addAll(files);
            return this;
        }

        @Override
        public CreateGameCdnSiteRequest build() {
            return new CreateGameCdnSiteRequest(this.displayName, this.files);
        }
    }

    public static interface _FinalStage {
        public CreateGameCdnSiteRequest build();

        public _FinalStage files(List<PrepareFile> var1);

        public _FinalStage addFiles(PrepareFile var1);

        public _FinalStage addAllFiles(List<PrepareFile> var1);
    }

    public static interface DisplayNameStage {
        public _FinalStage displayName(String var1);

        public Builder from(CreateGameCdnSiteRequest var1);
    }
}

