/*
 * Decompiled with CFR 0.152.
 */
package com.rivet.api.resources.cloud.common.types;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.rivet.api.core.ObjectMappers;
import java.time.OffsetDateTime;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class LogsPerfSpan {
    private final String label;
    private final OffsetDateTime startTs;
    private final Optional<OffsetDateTime> finishTs;
    private final Optional<UUID> reqId;

    private LogsPerfSpan(String label, OffsetDateTime startTs, Optional<OffsetDateTime> finishTs, Optional<UUID> reqId) {
        this.label = label;
        this.startTs = startTs;
        this.finishTs = finishTs;
        this.reqId = reqId;
    }

    @JsonProperty(value="label")
    public String getLabel() {
        return this.label;
    }

    @JsonProperty(value="start_ts")
    public OffsetDateTime getStartTs() {
        return this.startTs;
    }

    @JsonProperty(value="finish_ts")
    public Optional<OffsetDateTime> getFinishTs() {
        return this.finishTs;
    }

    @JsonProperty(value="req_id")
    public Optional<UUID> getReqId() {
        return this.reqId;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof LogsPerfSpan && this.equalTo((LogsPerfSpan)other);
    }

    private boolean equalTo(LogsPerfSpan other) {
        return this.label.equals(other.label) && this.startTs.equals(other.startTs) && this.finishTs.equals(other.finishTs) && this.reqId.equals(other.reqId);
    }

    public int hashCode() {
        return Objects.hash(this.label, this.startTs, this.finishTs, this.reqId);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static LabelStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements LabelStage,
    StartTsStage,
    _FinalStage {
        private String label;
        private OffsetDateTime startTs;
        private Optional<UUID> reqId = Optional.empty();
        private Optional<OffsetDateTime> finishTs = Optional.empty();

        private Builder() {
        }

        @Override
        public Builder from(LogsPerfSpan other) {
            this.label(other.getLabel());
            this.startTs(other.getStartTs());
            this.finishTs(other.getFinishTs());
            this.reqId(other.getReqId());
            return this;
        }

        @Override
        @JsonSetter(value="label")
        public StartTsStage label(String label) {
            this.label = label;
            return this;
        }

        @Override
        @JsonSetter(value="start_ts")
        public _FinalStage startTs(OffsetDateTime startTs) {
            this.startTs = startTs;
            return this;
        }

        @Override
        public _FinalStage reqId(UUID reqId) {
            this.reqId = Optional.of(reqId);
            return this;
        }

        @Override
        @JsonSetter(value="req_id", nulls=Nulls.SKIP)
        public _FinalStage reqId(Optional<UUID> reqId) {
            this.reqId = reqId;
            return this;
        }

        @Override
        public _FinalStage finishTs(OffsetDateTime finishTs) {
            this.finishTs = Optional.of(finishTs);
            return this;
        }

        @Override
        @JsonSetter(value="finish_ts", nulls=Nulls.SKIP)
        public _FinalStage finishTs(Optional<OffsetDateTime> finishTs) {
            this.finishTs = finishTs;
            return this;
        }

        @Override
        public LogsPerfSpan build() {
            return new LogsPerfSpan(this.label, this.startTs, this.finishTs, this.reqId);
        }
    }

    public static interface _FinalStage {
        public LogsPerfSpan build();

        public _FinalStage finishTs(Optional<OffsetDateTime> var1);

        public _FinalStage finishTs(OffsetDateTime var1);

        public _FinalStage reqId(Optional<UUID> var1);

        public _FinalStage reqId(UUID var1);
    }

    public static interface StartTsStage {
        public _FinalStage startTs(OffsetDateTime var1);
    }

    public static interface LabelStage {
        public StartTsStage label(String var1);

        public Builder from(LogsPerfSpan var1);
    }
}

