/*
 * Decompiled with CFR 0.152.
 */
package com.rivet.api.resources.cloud.common.types;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.rivet.api.core.ObjectMappers;
import com.rivet.api.resources.cloud.common.types.CdnNamespaceDomainVerificationMethod;
import com.rivet.api.resources.cloud.common.types.CdnNamespaceDomainVerificationStatus;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class CdnNamespaceDomain {
    private final String domain;
    private final OffsetDateTime createTs;
    private final CdnNamespaceDomainVerificationStatus verificationStatus;
    private final CdnNamespaceDomainVerificationMethod verificationMethod;
    private final List<String> verificationErrors;

    private CdnNamespaceDomain(String domain, OffsetDateTime createTs, CdnNamespaceDomainVerificationStatus verificationStatus, CdnNamespaceDomainVerificationMethod verificationMethod, List<String> verificationErrors) {
        this.domain = domain;
        this.createTs = createTs;
        this.verificationStatus = verificationStatus;
        this.verificationMethod = verificationMethod;
        this.verificationErrors = verificationErrors;
    }

    @JsonProperty(value="domain")
    public String getDomain() {
        return this.domain;
    }

    @JsonProperty(value="create_ts")
    public OffsetDateTime getCreateTs() {
        return this.createTs;
    }

    @JsonProperty(value="verification_status")
    public CdnNamespaceDomainVerificationStatus getVerificationStatus() {
        return this.verificationStatus;
    }

    @JsonProperty(value="verification_method")
    public CdnNamespaceDomainVerificationMethod getVerificationMethod() {
        return this.verificationMethod;
    }

    @JsonProperty(value="verification_errors")
    public List<String> getVerificationErrors() {
        return this.verificationErrors;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof CdnNamespaceDomain && this.equalTo((CdnNamespaceDomain)other);
    }

    private boolean equalTo(CdnNamespaceDomain other) {
        return this.domain.equals(other.domain) && this.createTs.equals(other.createTs) && this.verificationStatus.equals((Object)other.verificationStatus) && this.verificationMethod.equals(other.verificationMethod) && this.verificationErrors.equals(other.verificationErrors);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.domain, this.createTs, this.verificationStatus, this.verificationMethod, this.verificationErrors});
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static DomainStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements DomainStage,
    CreateTsStage,
    VerificationStatusStage,
    VerificationMethodStage,
    _FinalStage {
        private String domain;
        private OffsetDateTime createTs;
        private CdnNamespaceDomainVerificationStatus verificationStatus;
        private CdnNamespaceDomainVerificationMethod verificationMethod;
        private List<String> verificationErrors = new ArrayList<String>();

        private Builder() {
        }

        @Override
        public Builder from(CdnNamespaceDomain other) {
            this.domain(other.getDomain());
            this.createTs(other.getCreateTs());
            this.verificationStatus(other.getVerificationStatus());
            this.verificationMethod(other.getVerificationMethod());
            this.verificationErrors(other.getVerificationErrors());
            return this;
        }

        @Override
        @JsonSetter(value="domain")
        public CreateTsStage domain(String domain) {
            this.domain = domain;
            return this;
        }

        @Override
        @JsonSetter(value="create_ts")
        public VerificationStatusStage createTs(OffsetDateTime createTs) {
            this.createTs = createTs;
            return this;
        }

        @Override
        @JsonSetter(value="verification_status")
        public VerificationMethodStage verificationStatus(CdnNamespaceDomainVerificationStatus verificationStatus) {
            this.verificationStatus = verificationStatus;
            return this;
        }

        @Override
        @JsonSetter(value="verification_method")
        public _FinalStage verificationMethod(CdnNamespaceDomainVerificationMethod verificationMethod) {
            this.verificationMethod = verificationMethod;
            return this;
        }

        @Override
        public _FinalStage addAllVerificationErrors(List<String> verificationErrors) {
            this.verificationErrors.addAll(verificationErrors);
            return this;
        }

        @Override
        public _FinalStage addVerificationErrors(String verificationErrors) {
            this.verificationErrors.add(verificationErrors);
            return this;
        }

        @Override
        @JsonSetter(value="verification_errors", nulls=Nulls.SKIP)
        public _FinalStage verificationErrors(List<String> verificationErrors) {
            this.verificationErrors.clear();
            this.verificationErrors.addAll(verificationErrors);
            return this;
        }

        @Override
        public CdnNamespaceDomain build() {
            return new CdnNamespaceDomain(this.domain, this.createTs, this.verificationStatus, this.verificationMethod, this.verificationErrors);
        }
    }

    public static interface _FinalStage {
        public CdnNamespaceDomain build();

        public _FinalStage verificationErrors(List<String> var1);

        public _FinalStage addVerificationErrors(String var1);

        public _FinalStage addAllVerificationErrors(List<String> var1);
    }

    public static interface VerificationMethodStage {
        public _FinalStage verificationMethod(CdnNamespaceDomainVerificationMethod var1);
    }

    public static interface VerificationStatusStage {
        public VerificationMethodStage verificationStatus(CdnNamespaceDomainVerificationStatus var1);
    }

    public static interface CreateTsStage {
        public VerificationStatusStage createTs(OffsetDateTime var1);
    }

    public static interface DomainStage {
        public CreateTsStage domain(String var1);

        public Builder from(CdnNamespaceDomain var1);
    }
}

