/*
 * Decompiled with CFR 0.152.
 */
package com.rivet.api.resources.chat.common.types;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.rivet.api.core.ObjectMappers;
import com.rivet.api.resources.chat.common.types.TopicDirect;
import com.rivet.api.resources.chat.common.types.TopicGroup;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class Topic {
    private final Optional<TopicGroup> group;
    private final Optional<TopicDirect> direct;

    private Topic(Optional<TopicGroup> group, Optional<TopicDirect> direct) {
        this.group = group;
        this.direct = direct;
    }

    @JsonProperty(value="group")
    public Optional<TopicGroup> getGroup() {
        return this.group;
    }

    @JsonProperty(value="direct")
    public Optional<TopicDirect> getDirect() {
        return this.direct;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof Topic && this.equalTo((Topic)other);
    }

    private boolean equalTo(Topic other) {
        return this.group.equals(other.group) && this.direct.equals(other.direct);
    }

    public int hashCode() {
        return Objects.hash(this.group, this.direct);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<TopicGroup> group = Optional.empty();
        private Optional<TopicDirect> direct = Optional.empty();

        private Builder() {
        }

        public Builder from(Topic other) {
            this.group(other.getGroup());
            this.direct(other.getDirect());
            return this;
        }

        @JsonSetter(value="group", nulls=Nulls.SKIP)
        public Builder group(Optional<TopicGroup> group) {
            this.group = group;
            return this;
        }

        public Builder group(TopicGroup group) {
            this.group = Optional.of(group);
            return this;
        }

        @JsonSetter(value="direct", nulls=Nulls.SKIP)
        public Builder direct(Optional<TopicDirect> direct) {
            this.direct = direct;
            return this;
        }

        public Builder direct(TopicDirect direct) {
            this.direct = Optional.of(direct);
            return this;
        }

        public Topic build() {
            return new Topic(this.group, this.direct);
        }
    }
}

