/*
 * Decompiled with CFR 0.152.
 */
package com.rivet.api.resources.chat.common.types;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.rivet.api.core.ObjectMappers;
import com.rivet.api.resources.identity.common.types.Handle;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class MessageBodyText {
    private final Handle sender;
    private final String body;

    private MessageBodyText(Handle sender, String body) {
        this.sender = sender;
        this.body = body;
    }

    @JsonProperty(value="sender")
    public Handle getSender() {
        return this.sender;
    }

    @JsonProperty(value="body")
    public String getBody() {
        return this.body;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof MessageBodyText && this.equalTo((MessageBodyText)other);
    }

    private boolean equalTo(MessageBodyText other) {
        return this.sender.equals(other.sender) && this.body.equals(other.body);
    }

    public int hashCode() {
        return Objects.hash(this.sender, this.body);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static SenderStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements SenderStage,
    BodyStage,
    _FinalStage {
        private Handle sender;
        private String body;

        private Builder() {
        }

        @Override
        public Builder from(MessageBodyText other) {
            this.sender(other.getSender());
            this.body(other.getBody());
            return this;
        }

        @Override
        @JsonSetter(value="sender")
        public BodyStage sender(Handle sender) {
            this.sender = sender;
            return this;
        }

        @Override
        @JsonSetter(value="body")
        public _FinalStage body(String body) {
            this.body = body;
            return this;
        }

        @Override
        public MessageBodyText build() {
            return new MessageBodyText(this.sender, this.body);
        }
    }

    public static interface _FinalStage {
        public MessageBodyText build();
    }

    public static interface BodyStage {
        public _FinalStage body(String var1);
    }

    public static interface SenderStage {
        public BodyStage sender(Handle var1);

        public Builder from(MessageBodyText var1);
    }
}

