package com.rivet.api.resources.group.joinrequests;

import com.rivet.api.core.ApiError;
import com.rivet.api.core.ClientOptions;
import com.rivet.api.core.ObjectMappers;
import com.rivet.api.core.RequestOptions;
import com.rivet.api.resources.group.joinrequests.types.ResolveJoinRequestRequest;
import java.io.IOException;
import java.util.UUID;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class JoinRequestsClient {
    protected final ClientOptions clientOptions;

    public JoinRequestsClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
    }

    public void createJoinRequest(UUID groupId) {
        createJoinRequest(groupId, null);
    }

    public void createJoinRequest(UUID groupId, RequestOptions requestOptions) {
        HttpUrl _httpUrl = HttpUrl.parse(this.clientOptions.environment().getgroupURL())
                .newBuilder()
                .addPathSegments("groups")
                .addPathSegment(groupId.toString())
                .addPathSegments("join-request")
                .build();
        Request _request = new Request.Builder()
                .url(_httpUrl)
                .method("POST", RequestBody.create("", null))
                .headers(Headers.of(clientOptions.headers(requestOptions)))
                .build();
        try {
            Response _response = clientOptions.httpClient().newCall(_request).execute();
            if (_response.isSuccessful()) {
                return;
            }
            throw new ApiError(
                    _response.code(),
                    ObjectMappers.JSON_MAPPER.readValue(_response.body().string(), Object.class));
        } catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void resolveJoinRequest(UUID groupId, UUID identityId, ResolveJoinRequestRequest request) {
        resolveJoinRequest(groupId, identityId, request, null);
    }

    public void resolveJoinRequest(
            UUID groupId, UUID identityId, ResolveJoinRequestRequest request, RequestOptions requestOptions) {
        HttpUrl _httpUrl = HttpUrl.parse(this.clientOptions.environment().getgroupURL())
                .newBuilder()
                .addPathSegments("groups")
                .addPathSegment(groupId.toString())
                .addPathSegments("join-request")
                .addPathSegment(identityId.toString())
                .build();
        RequestBody _requestBody;
        try {
            _requestBody = RequestBody.create(
                    ObjectMappers.JSON_MAPPER.writeValueAsBytes(request), MediaType.parse("application/json"));
        } catch (Exception e) {
            throw new RuntimeException(e);
        }
        Request _request = new Request.Builder()
                .url(_httpUrl)
                .method("POST", _requestBody)
                .headers(Headers.of(clientOptions.headers(requestOptions)))
                .addHeader("Content-Type", "application/json")
                .build();
        try {
            Response _response = clientOptions.httpClient().newCall(_request).execute();
            if (_response.isSuccessful()) {
                return;
            }
            throw new ApiError(
                    _response.code(),
                    ObjectMappers.JSON_MAPPER.readValue(_response.body().string(), Object.class));
        } catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}
