package com.rivet.api.resources.cloud.games.games;

import com.rivet.api.core.ApiError;
import com.rivet.api.core.ClientOptions;
import com.rivet.api.core.ObjectMappers;
import com.rivet.api.core.RequestOptions;
import com.rivet.api.resources.cloud.games.games.requests.GetGameByIdRequest;
import com.rivet.api.resources.cloud.games.games.requests.GetGamesRequest;
import com.rivet.api.resources.cloud.games.games.types.CreateGameRequest;
import com.rivet.api.resources.cloud.games.games.types.CreateGameResponse;
import com.rivet.api.resources.cloud.games.games.types.GameBannerUploadPrepareRequest;
import com.rivet.api.resources.cloud.games.games.types.GameBannerUploadPrepareResponse;
import com.rivet.api.resources.cloud.games.games.types.GameLogoUploadPrepareRequest;
import com.rivet.api.resources.cloud.games.games.types.GameLogoUploadPrepareResponse;
import com.rivet.api.resources.cloud.games.games.types.GetGameByIdResponse;
import com.rivet.api.resources.cloud.games.games.types.GetGamesResponse;
import com.rivet.api.resources.cloud.games.games.types.ValidateGameRequest;
import com.rivet.api.resources.cloud.games.games.types.ValidateGameResponse;
import java.io.IOException;
import java.util.UUID;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class GamesClient {
    protected final ClientOptions clientOptions;

    public GamesClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
    }

    public GetGamesResponse getGames(GetGamesRequest request) {
        return getGames(request, null);
    }

    public GetGamesResponse getGames(GetGamesRequest request, RequestOptions requestOptions) {
        HttpUrl.Builder _httpUrl = HttpUrl.parse(
                        this.clientOptions.environment().getcloudURL())
                .newBuilder()
                .addPathSegments("games");
        if (request.getWatchIndex().isPresent()) {
            _httpUrl.addQueryParameter("watch_index", request.getWatchIndex().get());
        }
        RequestBody _requestBody = null;
        Request.Builder _requestBuilder = new Request.Builder()
                .url(_httpUrl.build())
                .method("GET", _requestBody)
                .headers(Headers.of(clientOptions.headers(requestOptions)))
                .addHeader("Content-Type", "application/json");
        Request _request = _requestBuilder.build();
        try {
            Response _response = clientOptions.httpClient().newCall(_request).execute();
            if (_response.isSuccessful()) {
                return ObjectMappers.JSON_MAPPER.readValue(_response.body().string(), GetGamesResponse.class);
            }
            throw new ApiError(
                    _response.code(),
                    ObjectMappers.JSON_MAPPER.readValue(_response.body().string(), Object.class));
        } catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public CreateGameResponse createGame(CreateGameRequest request) {
        return createGame(request, null);
    }

    public CreateGameResponse createGame(CreateGameRequest request, RequestOptions requestOptions) {
        HttpUrl _httpUrl = HttpUrl.parse(this.clientOptions.environment().getcloudURL())
                .newBuilder()
                .addPathSegments("games")
                .build();
        RequestBody _requestBody;
        try {
            _requestBody = RequestBody.create(
                    ObjectMappers.JSON_MAPPER.writeValueAsBytes(request), MediaType.parse("application/json"));
        } catch (Exception e) {
            throw new RuntimeException(e);
        }
        Request _request = new Request.Builder()
                .url(_httpUrl)
                .method("POST", _requestBody)
                .headers(Headers.of(clientOptions.headers(requestOptions)))
                .addHeader("Content-Type", "application/json")
                .build();
        try {
            Response _response = clientOptions.httpClient().newCall(_request).execute();
            if (_response.isSuccessful()) {
                return ObjectMappers.JSON_MAPPER.readValue(_response.body().string(), CreateGameResponse.class);
            }
            throw new ApiError(
                    _response.code(),
                    ObjectMappers.JSON_MAPPER.readValue(_response.body().string(), Object.class));
        } catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public ValidateGameResponse validateGame(ValidateGameRequest request) {
        return validateGame(request, null);
    }

    public ValidateGameResponse validateGame(ValidateGameRequest request, RequestOptions requestOptions) {
        HttpUrl _httpUrl = HttpUrl.parse(this.clientOptions.environment().getcloudURL())
                .newBuilder()
                .addPathSegments("games")
                .addPathSegments("validate")
                .build();
        RequestBody _requestBody;
        try {
            _requestBody = RequestBody.create(
                    ObjectMappers.JSON_MAPPER.writeValueAsBytes(request), MediaType.parse("application/json"));
        } catch (Exception e) {
            throw new RuntimeException(e);
        }
        Request _request = new Request.Builder()
                .url(_httpUrl)
                .method("POST", _requestBody)
                .headers(Headers.of(clientOptions.headers(requestOptions)))
                .addHeader("Content-Type", "application/json")
                .build();
        try {
            Response _response = clientOptions.httpClient().newCall(_request).execute();
            if (_response.isSuccessful()) {
                return ObjectMappers.JSON_MAPPER.readValue(_response.body().string(), ValidateGameResponse.class);
            }
            throw new ApiError(
                    _response.code(),
                    ObjectMappers.JSON_MAPPER.readValue(_response.body().string(), Object.class));
        } catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public GetGameByIdResponse getGameById(UUID gameId, GetGameByIdRequest request) {
        return getGameById(gameId, request, null);
    }

    public GetGameByIdResponse getGameById(UUID gameId, GetGameByIdRequest request, RequestOptions requestOptions) {
        HttpUrl.Builder _httpUrl = HttpUrl.parse(
                        this.clientOptions.environment().getcloudURL())
                .newBuilder()
                .addPathSegments("games")
                .addPathSegment(gameId.toString());
        if (request.getWatchIndex().isPresent()) {
            _httpUrl.addQueryParameter("watch_index", request.getWatchIndex().get());
        }
        RequestBody _requestBody = null;
        Request.Builder _requestBuilder = new Request.Builder()
                .url(_httpUrl.build())
                .method("GET", _requestBody)
                .headers(Headers.of(clientOptions.headers(requestOptions)))
                .addHeader("Content-Type", "application/json");
        Request _request = _requestBuilder.build();
        try {
            Response _response = clientOptions.httpClient().newCall(_request).execute();
            if (_response.isSuccessful()) {
                return ObjectMappers.JSON_MAPPER.readValue(_response.body().string(), GetGameByIdResponse.class);
            }
            throw new ApiError(
                    _response.code(),
                    ObjectMappers.JSON_MAPPER.readValue(_response.body().string(), Object.class));
        } catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public GameBannerUploadPrepareResponse gameBannerUploadPrepare(
            UUID gameId, GameBannerUploadPrepareRequest request) {
        return gameBannerUploadPrepare(gameId, request, null);
    }

    public GameBannerUploadPrepareResponse gameBannerUploadPrepare(
            UUID gameId, GameBannerUploadPrepareRequest request, RequestOptions requestOptions) {
        HttpUrl _httpUrl = HttpUrl.parse(this.clientOptions.environment().getcloudURL())
                .newBuilder()
                .addPathSegments("games")
                .addPathSegment(gameId.toString())
                .addPathSegments("banner-upload/prepare")
                .build();
        RequestBody _requestBody;
        try {
            _requestBody = RequestBody.create(
                    ObjectMappers.JSON_MAPPER.writeValueAsBytes(request), MediaType.parse("application/json"));
        } catch (Exception e) {
            throw new RuntimeException(e);
        }
        Request _request = new Request.Builder()
                .url(_httpUrl)
                .method("POST", _requestBody)
                .headers(Headers.of(clientOptions.headers(requestOptions)))
                .addHeader("Content-Type", "application/json")
                .build();
        try {
            Response _response = clientOptions.httpClient().newCall(_request).execute();
            if (_response.isSuccessful()) {
                return ObjectMappers.JSON_MAPPER.readValue(
                        _response.body().string(), GameBannerUploadPrepareResponse.class);
            }
            throw new ApiError(
                    _response.code(),
                    ObjectMappers.JSON_MAPPER.readValue(_response.body().string(), Object.class));
        } catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void gameBannerUploadComplete(UUID gameId, UUID uploadId) {
        gameBannerUploadComplete(gameId, uploadId, null);
    }

    public void gameBannerUploadComplete(UUID gameId, UUID uploadId, RequestOptions requestOptions) {
        HttpUrl _httpUrl = HttpUrl.parse(this.clientOptions.environment().getcloudURL())
                .newBuilder()
                .addPathSegments("games")
                .addPathSegment(gameId.toString())
                .addPathSegments("banner-upload")
                .addPathSegment(uploadId.toString())
                .addPathSegments("complete")
                .build();
        Request _request = new Request.Builder()
                .url(_httpUrl)
                .method("POST", RequestBody.create("", null))
                .headers(Headers.of(clientOptions.headers(requestOptions)))
                .build();
        try {
            Response _response = clientOptions.httpClient().newCall(_request).execute();
            if (_response.isSuccessful()) {
                return;
            }
            throw new ApiError(
                    _response.code(),
                    ObjectMappers.JSON_MAPPER.readValue(_response.body().string(), Object.class));
        } catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public GameLogoUploadPrepareResponse gameLogoUploadPrepare(UUID gameId, GameLogoUploadPrepareRequest request) {
        return gameLogoUploadPrepare(gameId, request, null);
    }

    public GameLogoUploadPrepareResponse gameLogoUploadPrepare(
            UUID gameId, GameLogoUploadPrepareRequest request, RequestOptions requestOptions) {
        HttpUrl _httpUrl = HttpUrl.parse(this.clientOptions.environment().getcloudURL())
                .newBuilder()
                .addPathSegments("games")
                .addPathSegment(gameId.toString())
                .addPathSegments("logo-upload/prepare")
                .build();
        RequestBody _requestBody;
        try {
            _requestBody = RequestBody.create(
                    ObjectMappers.JSON_MAPPER.writeValueAsBytes(request), MediaType.parse("application/json"));
        } catch (Exception e) {
            throw new RuntimeException(e);
        }
        Request _request = new Request.Builder()
                .url(_httpUrl)
                .method("POST", _requestBody)
                .headers(Headers.of(clientOptions.headers(requestOptions)))
                .addHeader("Content-Type", "application/json")
                .build();
        try {
            Response _response = clientOptions.httpClient().newCall(_request).execute();
            if (_response.isSuccessful()) {
                return ObjectMappers.JSON_MAPPER.readValue(
                        _response.body().string(), GameLogoUploadPrepareResponse.class);
            }
            throw new ApiError(
                    _response.code(),
                    ObjectMappers.JSON_MAPPER.readValue(_response.body().string(), Object.class));
        } catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void gameLogoUploadComplete(UUID gameId, UUID uploadId) {
        gameLogoUploadComplete(gameId, uploadId, null);
    }

    public void gameLogoUploadComplete(UUID gameId, UUID uploadId, RequestOptions requestOptions) {
        HttpUrl _httpUrl = HttpUrl.parse(this.clientOptions.environment().getcloudURL())
                .newBuilder()
                .addPathSegments("games")
                .addPathSegment(gameId.toString())
                .addPathSegments("logo-upload")
                .addPathSegment(uploadId.toString())
                .addPathSegments("complete")
                .build();
        Request _request = new Request.Builder()
                .url(_httpUrl)
                .method("POST", RequestBody.create("", null))
                .headers(Headers.of(clientOptions.headers(requestOptions)))
                .build();
        try {
            Response _response = clientOptions.httpClient().newCall(_request).execute();
            if (_response.isSuccessful()) {
                return;
            }
            throw new ApiError(
                    _response.code(),
                    ObjectMappers.JSON_MAPPER.readValue(_response.body().string(), Object.class));
        } catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}
