/*
 * Decompiled with CFR 0.152.
 */
package com.rivet.api.resources.module.requests;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.rivet.api.core.ObjectMappers;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class FindLobbyRequest {
    private final Optional<String> origin;
    private final Optional<UUID> namespaceId;
    private final Object data;

    private FindLobbyRequest(Optional<String> origin, Optional<UUID> namespaceId, Object data) {
        this.origin = origin;
        this.namespaceId = namespaceId;
        this.data = data;
    }

    @JsonProperty(value="origin")
    public Optional<String> getOrigin() {
        return this.origin;
    }

    @JsonProperty(value="namespace_id")
    public Optional<UUID> getNamespaceId() {
        return this.namespaceId;
    }

    @JsonProperty(value="data")
    public Object getData() {
        return this.data;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof FindLobbyRequest && this.equalTo((FindLobbyRequest)other);
    }

    private boolean equalTo(FindLobbyRequest other) {
        return this.origin.equals(other.origin) && this.namespaceId.equals(other.namespaceId) && this.data.equals(other.data);
    }

    public int hashCode() {
        return Objects.hash(this.origin, this.namespaceId, this.data);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static DataStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements DataStage,
    _FinalStage {
        private Object data;
        private Optional<UUID> namespaceId = Optional.empty();
        private Optional<String> origin = Optional.empty();

        private Builder() {
        }

        @Override
        public Builder from(FindLobbyRequest other) {
            this.origin(other.getOrigin());
            this.namespaceId(other.getNamespaceId());
            this.data(other.getData());
            return this;
        }

        @Override
        @JsonSetter(value="data")
        public _FinalStage data(Object data) {
            this.data = data;
            return this;
        }

        @Override
        public _FinalStage namespaceId(UUID namespaceId) {
            this.namespaceId = Optional.of(namespaceId);
            return this;
        }

        @Override
        @JsonSetter(value="namespace_id", nulls=Nulls.SKIP)
        public _FinalStage namespaceId(Optional<UUID> namespaceId) {
            this.namespaceId = namespaceId;
            return this;
        }

        @Override
        public _FinalStage origin(String origin) {
            this.origin = Optional.of(origin);
            return this;
        }

        @Override
        @JsonSetter(value="origin", nulls=Nulls.SKIP)
        public _FinalStage origin(Optional<String> origin) {
            this.origin = origin;
            return this;
        }

        @Override
        public FindLobbyRequest build() {
            return new FindLobbyRequest(this.origin, this.namespaceId, this.data);
        }
    }

    public static interface _FinalStage {
        public FindLobbyRequest build();

        public _FinalStage origin(Optional<String> var1);

        public _FinalStage origin(String var1);

        public _FinalStage namespaceId(Optional<UUID> var1);

        public _FinalStage namespaceId(UUID var1);
    }

    public static interface DataStage {
        public _FinalStage data(Object var1);

        public Builder from(FindLobbyRequest var1);
    }
}

