/*
 * Decompiled with CFR 0.152.
 */
package com.rivet.api.resources.kv.common.types;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.rivet.api.core.ObjectMappers;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class PutEntry {
    private final String key;
    private final Object value;

    private PutEntry(String key, Object value) {
        this.key = key;
        this.value = value;
    }

    @JsonProperty(value="key")
    public String getKey() {
        return this.key;
    }

    @JsonProperty(value="value")
    public Object getValue() {
        return this.value;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof PutEntry && this.equalTo((PutEntry)other);
    }

    private boolean equalTo(PutEntry other) {
        return this.key.equals(other.key) && this.value.equals(other.value);
    }

    public int hashCode() {
        return Objects.hash(this.key, this.value);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static KeyStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements KeyStage,
    ValueStage,
    _FinalStage {
        private String key;
        private Object value;

        private Builder() {
        }

        @Override
        public Builder from(PutEntry other) {
            this.key(other.getKey());
            this.value(other.getValue());
            return this;
        }

        @Override
        @JsonSetter(value="key")
        public ValueStage key(String key) {
            this.key = key;
            return this;
        }

        @Override
        @JsonSetter(value="value")
        public _FinalStage value(Object value) {
            this.value = value;
            return this;
        }

        @Override
        public PutEntry build() {
            return new PutEntry(this.key, this.value);
        }
    }

    public static interface _FinalStage {
        public PutEntry build();
    }

    public static interface ValueStage {
        public _FinalStage value(Object var1);
    }

    public static interface KeyStage {
        public ValueStage key(String var1);

        public Builder from(PutEntry var1);
    }
}

