/*
 * Decompiled with CFR 0.152.
 */
package com.rivet.api.resources.group.types;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.rivet.api.core.ObjectMappers;
import com.rivet.api.resources.group.common.types.Publicity;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class ValidateProfileRequest {
    private final Optional<String> displayName;
    private final Optional<String> bio;
    private final Optional<Publicity> publicity;

    private ValidateProfileRequest(Optional<String> displayName, Optional<String> bio, Optional<Publicity> publicity) {
        this.displayName = displayName;
        this.bio = bio;
        this.publicity = publicity;
    }

    @JsonProperty(value="display_name")
    public Optional<String> getDisplayName() {
        return this.displayName;
    }

    @JsonProperty(value="bio")
    public Optional<String> getBio() {
        return this.bio;
    }

    @JsonProperty(value="publicity")
    public Optional<Publicity> getPublicity() {
        return this.publicity;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof ValidateProfileRequest && this.equalTo((ValidateProfileRequest)other);
    }

    private boolean equalTo(ValidateProfileRequest other) {
        return this.displayName.equals(other.displayName) && this.bio.equals(other.bio) && this.publicity.equals(other.publicity);
    }

    public int hashCode() {
        return Objects.hash(this.displayName, this.bio, this.publicity);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> displayName = Optional.empty();
        private Optional<String> bio = Optional.empty();
        private Optional<Publicity> publicity = Optional.empty();

        private Builder() {
        }

        public Builder from(ValidateProfileRequest other) {
            this.displayName(other.getDisplayName());
            this.bio(other.getBio());
            this.publicity(other.getPublicity());
            return this;
        }

        @JsonSetter(value="display_name", nulls=Nulls.SKIP)
        public Builder displayName(Optional<String> displayName) {
            this.displayName = displayName;
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = Optional.of(displayName);
            return this;
        }

        @JsonSetter(value="bio", nulls=Nulls.SKIP)
        public Builder bio(Optional<String> bio) {
            this.bio = bio;
            return this;
        }

        public Builder bio(String bio) {
            this.bio = Optional.of(bio);
            return this;
        }

        @JsonSetter(value="publicity", nulls=Nulls.SKIP)
        public Builder publicity(Optional<Publicity> publicity) {
            this.publicity = publicity;
            return this;
        }

        public Builder publicity(Publicity publicity) {
            this.publicity = Optional.of(publicity);
            return this;
        }

        public ValidateProfileRequest build() {
            return new ValidateProfileRequest(this.displayName, this.bio, this.publicity);
        }
    }
}

