/*
 * Decompiled with CFR 0.152.
 */
package com.rivet.api.resources.group.invites.types;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.rivet.api.core.ObjectMappers;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class CreateInviteRequest {
    private final Optional<Double> ttl;
    private final Optional<Double> useCount;

    private CreateInviteRequest(Optional<Double> ttl, Optional<Double> useCount) {
        this.ttl = ttl;
        this.useCount = useCount;
    }

    @JsonProperty(value="ttl")
    public Optional<Double> getTtl() {
        return this.ttl;
    }

    @JsonProperty(value="use_count")
    public Optional<Double> getUseCount() {
        return this.useCount;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof CreateInviteRequest && this.equalTo((CreateInviteRequest)other);
    }

    private boolean equalTo(CreateInviteRequest other) {
        return this.ttl.equals(other.ttl) && this.useCount.equals(other.useCount);
    }

    public int hashCode() {
        return Objects.hash(this.ttl, this.useCount);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<Double> ttl = Optional.empty();
        private Optional<Double> useCount = Optional.empty();

        private Builder() {
        }

        public Builder from(CreateInviteRequest other) {
            this.ttl(other.getTtl());
            this.useCount(other.getUseCount());
            return this;
        }

        @JsonSetter(value="ttl", nulls=Nulls.SKIP)
        public Builder ttl(Optional<Double> ttl) {
            this.ttl = ttl;
            return this;
        }

        public Builder ttl(Double ttl) {
            this.ttl = Optional.of(ttl);
            return this;
        }

        @JsonSetter(value="use_count", nulls=Nulls.SKIP)
        public Builder useCount(Optional<Double> useCount) {
            this.useCount = useCount;
            return this;
        }

        public Builder useCount(Double useCount) {
            this.useCount = Optional.of(useCount);
            return this;
        }

        public CreateInviteRequest build() {
            return new CreateInviteRequest(this.ttl, this.useCount);
        }
    }
}

