/*
 * Decompiled with CFR 0.152.
 */
package com.rivet.api.resources.cloud.games.games.types;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.rivet.api.core.ObjectMappers;
import java.time.OffsetDateTime;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class GameSummary {
    private final UUID gameId;
    private final OffsetDateTime createTs;
    private final String nameId;
    private final String displayName;
    private final UUID developerGroupId;
    private final Optional<Integer> totalPlayerCount;
    private final Optional<String> logoUrl;
    private final Optional<String> bannerUrl;

    private GameSummary(UUID gameId, OffsetDateTime createTs, String nameId, String displayName, UUID developerGroupId, Optional<Integer> totalPlayerCount, Optional<String> logoUrl, Optional<String> bannerUrl) {
        this.gameId = gameId;
        this.createTs = createTs;
        this.nameId = nameId;
        this.displayName = displayName;
        this.developerGroupId = developerGroupId;
        this.totalPlayerCount = totalPlayerCount;
        this.logoUrl = logoUrl;
        this.bannerUrl = bannerUrl;
    }

    @JsonProperty(value="game_id")
    public UUID getGameId() {
        return this.gameId;
    }

    @JsonProperty(value="create_ts")
    public OffsetDateTime getCreateTs() {
        return this.createTs;
    }

    @JsonProperty(value="name_id")
    public String getNameId() {
        return this.nameId;
    }

    @JsonProperty(value="display_name")
    public String getDisplayName() {
        return this.displayName;
    }

    @JsonProperty(value="developer_group_id")
    public UUID getDeveloperGroupId() {
        return this.developerGroupId;
    }

    @JsonProperty(value="total_player_count")
    public Optional<Integer> getTotalPlayerCount() {
        return this.totalPlayerCount;
    }

    @JsonProperty(value="logo_url")
    public Optional<String> getLogoUrl() {
        return this.logoUrl;
    }

    @JsonProperty(value="banner_url")
    public Optional<String> getBannerUrl() {
        return this.bannerUrl;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof GameSummary && this.equalTo((GameSummary)other);
    }

    private boolean equalTo(GameSummary other) {
        return this.gameId.equals(other.gameId) && this.createTs.equals(other.createTs) && this.nameId.equals(other.nameId) && this.displayName.equals(other.displayName) && this.developerGroupId.equals(other.developerGroupId) && this.totalPlayerCount.equals(other.totalPlayerCount) && this.logoUrl.equals(other.logoUrl) && this.bannerUrl.equals(other.bannerUrl);
    }

    public int hashCode() {
        return Objects.hash(this.gameId, this.createTs, this.nameId, this.displayName, this.developerGroupId, this.totalPlayerCount, this.logoUrl, this.bannerUrl);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static GameIdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements GameIdStage,
    CreateTsStage,
    NameIdStage,
    DisplayNameStage,
    DeveloperGroupIdStage,
    _FinalStage {
        private UUID gameId;
        private OffsetDateTime createTs;
        private String nameId;
        private String displayName;
        private UUID developerGroupId;
        private Optional<String> bannerUrl = Optional.empty();
        private Optional<String> logoUrl = Optional.empty();
        private Optional<Integer> totalPlayerCount = Optional.empty();

        private Builder() {
        }

        @Override
        public Builder from(GameSummary other) {
            this.gameId(other.getGameId());
            this.createTs(other.getCreateTs());
            this.nameId(other.getNameId());
            this.displayName(other.getDisplayName());
            this.developerGroupId(other.getDeveloperGroupId());
            this.totalPlayerCount(other.getTotalPlayerCount());
            this.logoUrl(other.getLogoUrl());
            this.bannerUrl(other.getBannerUrl());
            return this;
        }

        @Override
        @JsonSetter(value="game_id")
        public CreateTsStage gameId(UUID gameId) {
            this.gameId = gameId;
            return this;
        }

        @Override
        @JsonSetter(value="create_ts")
        public NameIdStage createTs(OffsetDateTime createTs) {
            this.createTs = createTs;
            return this;
        }

        @Override
        @JsonSetter(value="name_id")
        public DisplayNameStage nameId(String nameId) {
            this.nameId = nameId;
            return this;
        }

        @Override
        @JsonSetter(value="display_name")
        public DeveloperGroupIdStage displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        @Override
        @JsonSetter(value="developer_group_id")
        public _FinalStage developerGroupId(UUID developerGroupId) {
            this.developerGroupId = developerGroupId;
            return this;
        }

        @Override
        public _FinalStage bannerUrl(String bannerUrl) {
            this.bannerUrl = Optional.of(bannerUrl);
            return this;
        }

        @Override
        @JsonSetter(value="banner_url", nulls=Nulls.SKIP)
        public _FinalStage bannerUrl(Optional<String> bannerUrl) {
            this.bannerUrl = bannerUrl;
            return this;
        }

        @Override
        public _FinalStage logoUrl(String logoUrl) {
            this.logoUrl = Optional.of(logoUrl);
            return this;
        }

        @Override
        @JsonSetter(value="logo_url", nulls=Nulls.SKIP)
        public _FinalStage logoUrl(Optional<String> logoUrl) {
            this.logoUrl = logoUrl;
            return this;
        }

        @Override
        public _FinalStage totalPlayerCount(Integer totalPlayerCount) {
            this.totalPlayerCount = Optional.of(totalPlayerCount);
            return this;
        }

        @Override
        @JsonSetter(value="total_player_count", nulls=Nulls.SKIP)
        public _FinalStage totalPlayerCount(Optional<Integer> totalPlayerCount) {
            this.totalPlayerCount = totalPlayerCount;
            return this;
        }

        @Override
        public GameSummary build() {
            return new GameSummary(this.gameId, this.createTs, this.nameId, this.displayName, this.developerGroupId, this.totalPlayerCount, this.logoUrl, this.bannerUrl);
        }
    }

    public static interface _FinalStage {
        public GameSummary build();

        public _FinalStage totalPlayerCount(Optional<Integer> var1);

        public _FinalStage totalPlayerCount(Integer var1);

        public _FinalStage logoUrl(Optional<String> var1);

        public _FinalStage logoUrl(String var1);

        public _FinalStage bannerUrl(Optional<String> var1);

        public _FinalStage bannerUrl(String var1);
    }

    public static interface DeveloperGroupIdStage {
        public _FinalStage developerGroupId(UUID var1);
    }

    public static interface DisplayNameStage {
        public DeveloperGroupIdStage displayName(String var1);
    }

    public static interface NameIdStage {
        public DisplayNameStage nameId(String var1);
    }

    public static interface CreateTsStage {
        public NameIdStage createTs(OffsetDateTime var1);
    }

    public static interface GameIdStage {
        public CreateTsStage gameId(UUID var1);

        public Builder from(GameSummary var1);
    }
}

