/*
 * Decompiled with CFR 0.152.
 */
package com.rivet.api.resources.cloud.common.types;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.rivet.api.core.ObjectMappers;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class MatchmakerNamespaceConfig {
    private final int lobbyCountMax;
    private final int maxPlayersPerClient;
    private final int maxPlayersPerClientVpn;
    private final int maxPlayersPerClientProxy;
    private final int maxPlayersPerClientTor;
    private final int maxPlayersPerClientHosting;

    private MatchmakerNamespaceConfig(int lobbyCountMax, int maxPlayersPerClient, int maxPlayersPerClientVpn, int maxPlayersPerClientProxy, int maxPlayersPerClientTor, int maxPlayersPerClientHosting) {
        this.lobbyCountMax = lobbyCountMax;
        this.maxPlayersPerClient = maxPlayersPerClient;
        this.maxPlayersPerClientVpn = maxPlayersPerClientVpn;
        this.maxPlayersPerClientProxy = maxPlayersPerClientProxy;
        this.maxPlayersPerClientTor = maxPlayersPerClientTor;
        this.maxPlayersPerClientHosting = maxPlayersPerClientHosting;
    }

    @JsonProperty(value="lobby_count_max")
    public int getLobbyCountMax() {
        return this.lobbyCountMax;
    }

    @JsonProperty(value="max_players_per_client")
    public int getMaxPlayersPerClient() {
        return this.maxPlayersPerClient;
    }

    @JsonProperty(value="max_players_per_client_vpn")
    public int getMaxPlayersPerClientVpn() {
        return this.maxPlayersPerClientVpn;
    }

    @JsonProperty(value="max_players_per_client_proxy")
    public int getMaxPlayersPerClientProxy() {
        return this.maxPlayersPerClientProxy;
    }

    @JsonProperty(value="max_players_per_client_tor")
    public int getMaxPlayersPerClientTor() {
        return this.maxPlayersPerClientTor;
    }

    @JsonProperty(value="max_players_per_client_hosting")
    public int getMaxPlayersPerClientHosting() {
        return this.maxPlayersPerClientHosting;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof MatchmakerNamespaceConfig && this.equalTo((MatchmakerNamespaceConfig)other);
    }

    private boolean equalTo(MatchmakerNamespaceConfig other) {
        return this.lobbyCountMax == other.lobbyCountMax && this.maxPlayersPerClient == other.maxPlayersPerClient && this.maxPlayersPerClientVpn == other.maxPlayersPerClientVpn && this.maxPlayersPerClientProxy == other.maxPlayersPerClientProxy && this.maxPlayersPerClientTor == other.maxPlayersPerClientTor && this.maxPlayersPerClientHosting == other.maxPlayersPerClientHosting;
    }

    public int hashCode() {
        return Objects.hash(this.lobbyCountMax, this.maxPlayersPerClient, this.maxPlayersPerClientVpn, this.maxPlayersPerClientProxy, this.maxPlayersPerClientTor, this.maxPlayersPerClientHosting);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static LobbyCountMaxStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements LobbyCountMaxStage,
    MaxPlayersPerClientStage,
    MaxPlayersPerClientVpnStage,
    MaxPlayersPerClientProxyStage,
    MaxPlayersPerClientTorStage,
    MaxPlayersPerClientHostingStage,
    _FinalStage {
        private int lobbyCountMax;
        private int maxPlayersPerClient;
        private int maxPlayersPerClientVpn;
        private int maxPlayersPerClientProxy;
        private int maxPlayersPerClientTor;
        private int maxPlayersPerClientHosting;

        private Builder() {
        }

        @Override
        public Builder from(MatchmakerNamespaceConfig other) {
            this.lobbyCountMax(other.getLobbyCountMax());
            this.maxPlayersPerClient(other.getMaxPlayersPerClient());
            this.maxPlayersPerClientVpn(other.getMaxPlayersPerClientVpn());
            this.maxPlayersPerClientProxy(other.getMaxPlayersPerClientProxy());
            this.maxPlayersPerClientTor(other.getMaxPlayersPerClientTor());
            this.maxPlayersPerClientHosting(other.getMaxPlayersPerClientHosting());
            return this;
        }

        @Override
        @JsonSetter(value="lobby_count_max")
        public MaxPlayersPerClientStage lobbyCountMax(int lobbyCountMax) {
            this.lobbyCountMax = lobbyCountMax;
            return this;
        }

        @Override
        @JsonSetter(value="max_players_per_client")
        public MaxPlayersPerClientVpnStage maxPlayersPerClient(int maxPlayersPerClient) {
            this.maxPlayersPerClient = maxPlayersPerClient;
            return this;
        }

        @Override
        @JsonSetter(value="max_players_per_client_vpn")
        public MaxPlayersPerClientProxyStage maxPlayersPerClientVpn(int maxPlayersPerClientVpn) {
            this.maxPlayersPerClientVpn = maxPlayersPerClientVpn;
            return this;
        }

        @Override
        @JsonSetter(value="max_players_per_client_proxy")
        public MaxPlayersPerClientTorStage maxPlayersPerClientProxy(int maxPlayersPerClientProxy) {
            this.maxPlayersPerClientProxy = maxPlayersPerClientProxy;
            return this;
        }

        @Override
        @JsonSetter(value="max_players_per_client_tor")
        public MaxPlayersPerClientHostingStage maxPlayersPerClientTor(int maxPlayersPerClientTor) {
            this.maxPlayersPerClientTor = maxPlayersPerClientTor;
            return this;
        }

        @Override
        @JsonSetter(value="max_players_per_client_hosting")
        public _FinalStage maxPlayersPerClientHosting(int maxPlayersPerClientHosting) {
            this.maxPlayersPerClientHosting = maxPlayersPerClientHosting;
            return this;
        }

        @Override
        public MatchmakerNamespaceConfig build() {
            return new MatchmakerNamespaceConfig(this.lobbyCountMax, this.maxPlayersPerClient, this.maxPlayersPerClientVpn, this.maxPlayersPerClientProxy, this.maxPlayersPerClientTor, this.maxPlayersPerClientHosting);
        }
    }

    public static interface _FinalStage {
        public MatchmakerNamespaceConfig build();
    }

    public static interface MaxPlayersPerClientHostingStage {
        public _FinalStage maxPlayersPerClientHosting(int var1);
    }

    public static interface MaxPlayersPerClientTorStage {
        public MaxPlayersPerClientHostingStage maxPlayersPerClientTor(int var1);
    }

    public static interface MaxPlayersPerClientProxyStage {
        public MaxPlayersPerClientTorStage maxPlayersPerClientProxy(int var1);
    }

    public static interface MaxPlayersPerClientVpnStage {
        public MaxPlayersPerClientProxyStage maxPlayersPerClientVpn(int var1);
    }

    public static interface MaxPlayersPerClientStage {
        public MaxPlayersPerClientVpnStage maxPlayersPerClient(int var1);
    }

    public static interface LobbyCountMaxStage {
        public MaxPlayersPerClientStage lobbyCountMax(int var1);

        public Builder from(MatchmakerNamespaceConfig var1);
    }
}

