/*
 * Decompiled with CFR 0.152.
 */
package com.rivet.api.resources.cloud.common.types;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.rivet.api.core.ObjectMappers;
import com.rivet.api.resources.cloud.common.types.LogsLobbyStatus;
import java.time.OffsetDateTime;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class LogsLobbySummary {
    private final UUID lobbyId;
    private final UUID namespaceId;
    private final String lobbyGroupNameId;
    private final UUID regionId;
    private final OffsetDateTime createTs;
    private final Optional<OffsetDateTime> startTs;
    private final Optional<OffsetDateTime> readyTs;
    private final LogsLobbyStatus status;

    private LogsLobbySummary(UUID lobbyId, UUID namespaceId, String lobbyGroupNameId, UUID regionId, OffsetDateTime createTs, Optional<OffsetDateTime> startTs, Optional<OffsetDateTime> readyTs, LogsLobbyStatus status) {
        this.lobbyId = lobbyId;
        this.namespaceId = namespaceId;
        this.lobbyGroupNameId = lobbyGroupNameId;
        this.regionId = regionId;
        this.createTs = createTs;
        this.startTs = startTs;
        this.readyTs = readyTs;
        this.status = status;
    }

    @JsonProperty(value="lobby_id")
    public UUID getLobbyId() {
        return this.lobbyId;
    }

    @JsonProperty(value="namespace_id")
    public UUID getNamespaceId() {
        return this.namespaceId;
    }

    @JsonProperty(value="lobby_group_name_id")
    public String getLobbyGroupNameId() {
        return this.lobbyGroupNameId;
    }

    @JsonProperty(value="region_id")
    public UUID getRegionId() {
        return this.regionId;
    }

    @JsonProperty(value="create_ts")
    public OffsetDateTime getCreateTs() {
        return this.createTs;
    }

    @JsonProperty(value="start_ts")
    public Optional<OffsetDateTime> getStartTs() {
        return this.startTs;
    }

    @JsonProperty(value="ready_ts")
    public Optional<OffsetDateTime> getReadyTs() {
        return this.readyTs;
    }

    @JsonProperty(value="status")
    public LogsLobbyStatus getStatus() {
        return this.status;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof LogsLobbySummary && this.equalTo((LogsLobbySummary)other);
    }

    private boolean equalTo(LogsLobbySummary other) {
        return this.lobbyId.equals(other.lobbyId) && this.namespaceId.equals(other.namespaceId) && this.lobbyGroupNameId.equals(other.lobbyGroupNameId) && this.regionId.equals(other.regionId) && this.createTs.equals(other.createTs) && this.startTs.equals(other.startTs) && this.readyTs.equals(other.readyTs) && this.status.equals(other.status);
    }

    public int hashCode() {
        return Objects.hash(this.lobbyId, this.namespaceId, this.lobbyGroupNameId, this.regionId, this.createTs, this.startTs, this.readyTs, this.status);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static LobbyIdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements LobbyIdStage,
    NamespaceIdStage,
    LobbyGroupNameIdStage,
    RegionIdStage,
    CreateTsStage,
    StatusStage,
    _FinalStage {
        private UUID lobbyId;
        private UUID namespaceId;
        private String lobbyGroupNameId;
        private UUID regionId;
        private OffsetDateTime createTs;
        private LogsLobbyStatus status;
        private Optional<OffsetDateTime> readyTs = Optional.empty();
        private Optional<OffsetDateTime> startTs = Optional.empty();

        private Builder() {
        }

        @Override
        public Builder from(LogsLobbySummary other) {
            this.lobbyId(other.getLobbyId());
            this.namespaceId(other.getNamespaceId());
            this.lobbyGroupNameId(other.getLobbyGroupNameId());
            this.regionId(other.getRegionId());
            this.createTs(other.getCreateTs());
            this.startTs(other.getStartTs());
            this.readyTs(other.getReadyTs());
            this.status(other.getStatus());
            return this;
        }

        @Override
        @JsonSetter(value="lobby_id")
        public NamespaceIdStage lobbyId(UUID lobbyId) {
            this.lobbyId = lobbyId;
            return this;
        }

        @Override
        @JsonSetter(value="namespace_id")
        public LobbyGroupNameIdStage namespaceId(UUID namespaceId) {
            this.namespaceId = namespaceId;
            return this;
        }

        @Override
        @JsonSetter(value="lobby_group_name_id")
        public RegionIdStage lobbyGroupNameId(String lobbyGroupNameId) {
            this.lobbyGroupNameId = lobbyGroupNameId;
            return this;
        }

        @Override
        @JsonSetter(value="region_id")
        public CreateTsStage regionId(UUID regionId) {
            this.regionId = regionId;
            return this;
        }

        @Override
        @JsonSetter(value="create_ts")
        public StatusStage createTs(OffsetDateTime createTs) {
            this.createTs = createTs;
            return this;
        }

        @Override
        @JsonSetter(value="status")
        public _FinalStage status(LogsLobbyStatus status) {
            this.status = status;
            return this;
        }

        @Override
        public _FinalStage readyTs(OffsetDateTime readyTs) {
            this.readyTs = Optional.of(readyTs);
            return this;
        }

        @Override
        @JsonSetter(value="ready_ts", nulls=Nulls.SKIP)
        public _FinalStage readyTs(Optional<OffsetDateTime> readyTs) {
            this.readyTs = readyTs;
            return this;
        }

        @Override
        public _FinalStage startTs(OffsetDateTime startTs) {
            this.startTs = Optional.of(startTs);
            return this;
        }

        @Override
        @JsonSetter(value="start_ts", nulls=Nulls.SKIP)
        public _FinalStage startTs(Optional<OffsetDateTime> startTs) {
            this.startTs = startTs;
            return this;
        }

        @Override
        public LogsLobbySummary build() {
            return new LogsLobbySummary(this.lobbyId, this.namespaceId, this.lobbyGroupNameId, this.regionId, this.createTs, this.startTs, this.readyTs, this.status);
        }
    }

    public static interface _FinalStage {
        public LogsLobbySummary build();

        public _FinalStage startTs(Optional<OffsetDateTime> var1);

        public _FinalStage startTs(OffsetDateTime var1);

        public _FinalStage readyTs(Optional<OffsetDateTime> var1);

        public _FinalStage readyTs(OffsetDateTime var1);
    }

    public static interface StatusStage {
        public _FinalStage status(LogsLobbyStatus var1);
    }

    public static interface CreateTsStage {
        public StatusStage createTs(OffsetDateTime var1);
    }

    public static interface RegionIdStage {
        public CreateTsStage regionId(UUID var1);
    }

    public static interface LobbyGroupNameIdStage {
        public RegionIdStage lobbyGroupNameId(String var1);
    }

    public static interface NamespaceIdStage {
        public LobbyGroupNameIdStage namespaceId(UUID var1);
    }

    public static interface LobbyIdStage {
        public NamespaceIdStage lobbyId(UUID var1);

        public Builder from(LogsLobbySummary var1);
    }
}

