/*
 * Decompiled with CFR 0.152.
 */
package com.rivet.api.resources.cloud.common.types;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.rivet.api.core.ObjectMappers;
import com.rivet.api.resources.cloud.common.types.LogsLobbyStatusStopped;
import com.rivet.api.resources.common.types.EmptyObject;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class LogsLobbyStatus {
    private final EmptyObject running;
    private final Optional<LogsLobbyStatusStopped> stopped;

    private LogsLobbyStatus(EmptyObject running, Optional<LogsLobbyStatusStopped> stopped) {
        this.running = running;
        this.stopped = stopped;
    }

    @JsonProperty(value="running")
    public EmptyObject getRunning() {
        return this.running;
    }

    @JsonProperty(value="stopped")
    public Optional<LogsLobbyStatusStopped> getStopped() {
        return this.stopped;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof LogsLobbyStatus && this.equalTo((LogsLobbyStatus)other);
    }

    private boolean equalTo(LogsLobbyStatus other) {
        return this.running.equals(other.running) && this.stopped.equals(other.stopped);
    }

    public int hashCode() {
        return Objects.hash(this.running, this.stopped);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static RunningStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements RunningStage,
    _FinalStage {
        private EmptyObject running;
        private Optional<LogsLobbyStatusStopped> stopped = Optional.empty();

        private Builder() {
        }

        @Override
        public Builder from(LogsLobbyStatus other) {
            this.running(other.getRunning());
            this.stopped(other.getStopped());
            return this;
        }

        @Override
        @JsonSetter(value="running")
        public _FinalStage running(EmptyObject running) {
            this.running = running;
            return this;
        }

        @Override
        public _FinalStage stopped(LogsLobbyStatusStopped stopped) {
            this.stopped = Optional.of(stopped);
            return this;
        }

        @Override
        @JsonSetter(value="stopped", nulls=Nulls.SKIP)
        public _FinalStage stopped(Optional<LogsLobbyStatusStopped> stopped) {
            this.stopped = stopped;
            return this;
        }

        @Override
        public LogsLobbyStatus build() {
            return new LogsLobbyStatus(this.running, this.stopped);
        }
    }

    public static interface _FinalStage {
        public LogsLobbyStatus build();

        public _FinalStage stopped(Optional<LogsLobbyStatusStopped> var1);

        public _FinalStage stopped(LogsLobbyStatusStopped var1);
    }

    public static interface RunningStage {
        public _FinalStage running(EmptyObject var1);

        public Builder from(LogsLobbyStatus var1);
    }
}

