/*
 * Decompiled with CFR 0.152.
 */
package com.rivet.api.resources.cloud.common.types;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.rivet.api.core.ObjectMappers;
import com.rivet.api.resources.cloud.common.types.NamespaceSummary;
import com.rivet.api.resources.cloud.common.types.RegionSummary;
import com.rivet.api.resources.cloud.version.types.Summary;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class GameFull {
    private final UUID gameId;
    private final OffsetDateTime createTs;
    private final String nameId;
    private final String displayName;
    private final UUID developerGroupId;
    private final int totalPlayerCount;
    private final Optional<String> logoUrl;
    private final Optional<String> bannerUrl;
    private final List<NamespaceSummary> namespaces;
    private final List<Summary> versions;
    private final List<RegionSummary> availableRegions;

    private GameFull(UUID gameId, OffsetDateTime createTs, String nameId, String displayName, UUID developerGroupId, int totalPlayerCount, Optional<String> logoUrl, Optional<String> bannerUrl, List<NamespaceSummary> namespaces, List<Summary> versions, List<RegionSummary> availableRegions) {
        this.gameId = gameId;
        this.createTs = createTs;
        this.nameId = nameId;
        this.displayName = displayName;
        this.developerGroupId = developerGroupId;
        this.totalPlayerCount = totalPlayerCount;
        this.logoUrl = logoUrl;
        this.bannerUrl = bannerUrl;
        this.namespaces = namespaces;
        this.versions = versions;
        this.availableRegions = availableRegions;
    }

    @JsonProperty(value="game_id")
    public UUID getGameId() {
        return this.gameId;
    }

    @JsonProperty(value="create_ts")
    public OffsetDateTime getCreateTs() {
        return this.createTs;
    }

    @JsonProperty(value="name_id")
    public String getNameId() {
        return this.nameId;
    }

    @JsonProperty(value="display_name")
    public String getDisplayName() {
        return this.displayName;
    }

    @JsonProperty(value="developer_group_id")
    public UUID getDeveloperGroupId() {
        return this.developerGroupId;
    }

    @JsonProperty(value="total_player_count")
    public int getTotalPlayerCount() {
        return this.totalPlayerCount;
    }

    @JsonProperty(value="logo_url")
    public Optional<String> getLogoUrl() {
        return this.logoUrl;
    }

    @JsonProperty(value="banner_url")
    public Optional<String> getBannerUrl() {
        return this.bannerUrl;
    }

    @JsonProperty(value="namespaces")
    public List<NamespaceSummary> getNamespaces() {
        return this.namespaces;
    }

    @JsonProperty(value="versions")
    public List<Summary> getVersions() {
        return this.versions;
    }

    @JsonProperty(value="available_regions")
    public List<RegionSummary> getAvailableRegions() {
        return this.availableRegions;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof GameFull && this.equalTo((GameFull)other);
    }

    private boolean equalTo(GameFull other) {
        return this.gameId.equals(other.gameId) && this.createTs.equals(other.createTs) && this.nameId.equals(other.nameId) && this.displayName.equals(other.displayName) && this.developerGroupId.equals(other.developerGroupId) && this.totalPlayerCount == other.totalPlayerCount && this.logoUrl.equals(other.logoUrl) && this.bannerUrl.equals(other.bannerUrl) && this.namespaces.equals(other.namespaces) && this.versions.equals(other.versions) && this.availableRegions.equals(other.availableRegions);
    }

    public int hashCode() {
        return Objects.hash(this.gameId, this.createTs, this.nameId, this.displayName, this.developerGroupId, this.totalPlayerCount, this.logoUrl, this.bannerUrl, this.namespaces, this.versions, this.availableRegions);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static GameIdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements GameIdStage,
    CreateTsStage,
    NameIdStage,
    DisplayNameStage,
    DeveloperGroupIdStage,
    TotalPlayerCountStage,
    _FinalStage {
        private UUID gameId;
        private OffsetDateTime createTs;
        private String nameId;
        private String displayName;
        private UUID developerGroupId;
        private int totalPlayerCount;
        private List<RegionSummary> availableRegions = new ArrayList<RegionSummary>();
        private List<Summary> versions = new ArrayList<Summary>();
        private List<NamespaceSummary> namespaces = new ArrayList<NamespaceSummary>();
        private Optional<String> bannerUrl = Optional.empty();
        private Optional<String> logoUrl = Optional.empty();

        private Builder() {
        }

        @Override
        public Builder from(GameFull other) {
            this.gameId(other.getGameId());
            this.createTs(other.getCreateTs());
            this.nameId(other.getNameId());
            this.displayName(other.getDisplayName());
            this.developerGroupId(other.getDeveloperGroupId());
            this.totalPlayerCount(other.getTotalPlayerCount());
            this.logoUrl(other.getLogoUrl());
            this.bannerUrl(other.getBannerUrl());
            this.namespaces(other.getNamespaces());
            this.versions(other.getVersions());
            this.availableRegions(other.getAvailableRegions());
            return this;
        }

        @Override
        @JsonSetter(value="game_id")
        public CreateTsStage gameId(UUID gameId) {
            this.gameId = gameId;
            return this;
        }

        @Override
        @JsonSetter(value="create_ts")
        public NameIdStage createTs(OffsetDateTime createTs) {
            this.createTs = createTs;
            return this;
        }

        @Override
        @JsonSetter(value="name_id")
        public DisplayNameStage nameId(String nameId) {
            this.nameId = nameId;
            return this;
        }

        @Override
        @JsonSetter(value="display_name")
        public DeveloperGroupIdStage displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        @Override
        @JsonSetter(value="developer_group_id")
        public TotalPlayerCountStage developerGroupId(UUID developerGroupId) {
            this.developerGroupId = developerGroupId;
            return this;
        }

        @Override
        @JsonSetter(value="total_player_count")
        public _FinalStage totalPlayerCount(int totalPlayerCount) {
            this.totalPlayerCount = totalPlayerCount;
            return this;
        }

        @Override
        public _FinalStage addAllAvailableRegions(List<RegionSummary> availableRegions) {
            this.availableRegions.addAll(availableRegions);
            return this;
        }

        @Override
        public _FinalStage addAvailableRegions(RegionSummary availableRegions) {
            this.availableRegions.add(availableRegions);
            return this;
        }

        @Override
        @JsonSetter(value="available_regions", nulls=Nulls.SKIP)
        public _FinalStage availableRegions(List<RegionSummary> availableRegions) {
            this.availableRegions.clear();
            this.availableRegions.addAll(availableRegions);
            return this;
        }

        @Override
        public _FinalStage addAllVersions(List<Summary> versions) {
            this.versions.addAll(versions);
            return this;
        }

        @Override
        public _FinalStage addVersions(Summary versions) {
            this.versions.add(versions);
            return this;
        }

        @Override
        @JsonSetter(value="versions", nulls=Nulls.SKIP)
        public _FinalStage versions(List<Summary> versions) {
            this.versions.clear();
            this.versions.addAll(versions);
            return this;
        }

        @Override
        public _FinalStage addAllNamespaces(List<NamespaceSummary> namespaces) {
            this.namespaces.addAll(namespaces);
            return this;
        }

        @Override
        public _FinalStage addNamespaces(NamespaceSummary namespaces) {
            this.namespaces.add(namespaces);
            return this;
        }

        @Override
        @JsonSetter(value="namespaces", nulls=Nulls.SKIP)
        public _FinalStage namespaces(List<NamespaceSummary> namespaces) {
            this.namespaces.clear();
            this.namespaces.addAll(namespaces);
            return this;
        }

        @Override
        public _FinalStage bannerUrl(String bannerUrl) {
            this.bannerUrl = Optional.of(bannerUrl);
            return this;
        }

        @Override
        @JsonSetter(value="banner_url", nulls=Nulls.SKIP)
        public _FinalStage bannerUrl(Optional<String> bannerUrl) {
            this.bannerUrl = bannerUrl;
            return this;
        }

        @Override
        public _FinalStage logoUrl(String logoUrl) {
            this.logoUrl = Optional.of(logoUrl);
            return this;
        }

        @Override
        @JsonSetter(value="logo_url", nulls=Nulls.SKIP)
        public _FinalStage logoUrl(Optional<String> logoUrl) {
            this.logoUrl = logoUrl;
            return this;
        }

        @Override
        public GameFull build() {
            return new GameFull(this.gameId, this.createTs, this.nameId, this.displayName, this.developerGroupId, this.totalPlayerCount, this.logoUrl, this.bannerUrl, this.namespaces, this.versions, this.availableRegions);
        }
    }

    public static interface _FinalStage {
        public GameFull build();

        public _FinalStage logoUrl(Optional<String> var1);

        public _FinalStage logoUrl(String var1);

        public _FinalStage bannerUrl(Optional<String> var1);

        public _FinalStage bannerUrl(String var1);

        public _FinalStage namespaces(List<NamespaceSummary> var1);

        public _FinalStage addNamespaces(NamespaceSummary var1);

        public _FinalStage addAllNamespaces(List<NamespaceSummary> var1);

        public _FinalStage versions(List<Summary> var1);

        public _FinalStage addVersions(Summary var1);

        public _FinalStage addAllVersions(List<Summary> var1);

        public _FinalStage availableRegions(List<RegionSummary> var1);

        public _FinalStage addAvailableRegions(RegionSummary var1);

        public _FinalStage addAllAvailableRegions(List<RegionSummary> var1);
    }

    public static interface TotalPlayerCountStage {
        public _FinalStage totalPlayerCount(int var1);
    }

    public static interface DeveloperGroupIdStage {
        public TotalPlayerCountStage developerGroupId(UUID var1);
    }

    public static interface DisplayNameStage {
        public DeveloperGroupIdStage displayName(String var1);
    }

    public static interface NameIdStage {
        public DisplayNameStage nameId(String var1);
    }

    public static interface CreateTsStage {
        public NameIdStage createTs(OffsetDateTime var1);
    }

    public static interface GameIdStage {
        public CreateTsStage gameId(UUID var1);

        public Builder from(GameFull var1);
    }
}

