/*
 * Decompiled with CFR 0.152.
 */
package com.rivet.api.resources.chat.common.types;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.rivet.api.core.ObjectMappers;
import com.rivet.api.resources.chat.common.types.Message;
import com.rivet.api.resources.chat.common.types.ThreadExternalLinks;
import com.rivet.api.resources.chat.common.types.Topic;
import java.time.OffsetDateTime;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class Thread {
    private final UUID threadId;
    private final OffsetDateTime createTs;
    private final Topic topic;
    private final Optional<Message> tailMessage;
    private final OffsetDateTime lastReadTs;
    private final long unreadCount;
    private final ThreadExternalLinks external;

    private Thread(UUID threadId, OffsetDateTime createTs, Topic topic, Optional<Message> tailMessage, OffsetDateTime lastReadTs, long unreadCount, ThreadExternalLinks external) {
        this.threadId = threadId;
        this.createTs = createTs;
        this.topic = topic;
        this.tailMessage = tailMessage;
        this.lastReadTs = lastReadTs;
        this.unreadCount = unreadCount;
        this.external = external;
    }

    @JsonProperty(value="thread_id")
    public UUID getThreadId() {
        return this.threadId;
    }

    @JsonProperty(value="create_ts")
    public OffsetDateTime getCreateTs() {
        return this.createTs;
    }

    @JsonProperty(value="topic")
    public Topic getTopic() {
        return this.topic;
    }

    @JsonProperty(value="tail_message")
    public Optional<Message> getTailMessage() {
        return this.tailMessage;
    }

    @JsonProperty(value="last_read_ts")
    public OffsetDateTime getLastReadTs() {
        return this.lastReadTs;
    }

    @JsonProperty(value="unread_count")
    public long getUnreadCount() {
        return this.unreadCount;
    }

    @JsonProperty(value="external")
    public ThreadExternalLinks getExternal() {
        return this.external;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof Thread && this.equalTo((Thread)other);
    }

    private boolean equalTo(Thread other) {
        return this.threadId.equals(other.threadId) && this.createTs.equals(other.createTs) && this.topic.equals(other.topic) && this.tailMessage.equals(other.tailMessage) && this.lastReadTs.equals(other.lastReadTs) && this.unreadCount == other.unreadCount && this.external.equals(other.external);
    }

    public int hashCode() {
        return Objects.hash(this.threadId, this.createTs, this.topic, this.tailMessage, this.lastReadTs, this.unreadCount, this.external);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static ThreadIdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements ThreadIdStage,
    CreateTsStage,
    TopicStage,
    LastReadTsStage,
    UnreadCountStage,
    ExternalStage,
    _FinalStage {
        private UUID threadId;
        private OffsetDateTime createTs;
        private Topic topic;
        private OffsetDateTime lastReadTs;
        private long unreadCount;
        private ThreadExternalLinks external;
        private Optional<Message> tailMessage = Optional.empty();

        private Builder() {
        }

        @Override
        public Builder from(Thread other) {
            this.threadId(other.getThreadId());
            this.createTs(other.getCreateTs());
            this.topic(other.getTopic());
            this.tailMessage(other.getTailMessage());
            this.lastReadTs(other.getLastReadTs());
            this.unreadCount(other.getUnreadCount());
            this.external(other.getExternal());
            return this;
        }

        @Override
        @JsonSetter(value="thread_id")
        public CreateTsStage threadId(UUID threadId) {
            this.threadId = threadId;
            return this;
        }

        @Override
        @JsonSetter(value="create_ts")
        public TopicStage createTs(OffsetDateTime createTs) {
            this.createTs = createTs;
            return this;
        }

        @Override
        @JsonSetter(value="topic")
        public LastReadTsStage topic(Topic topic) {
            this.topic = topic;
            return this;
        }

        @Override
        @JsonSetter(value="last_read_ts")
        public UnreadCountStage lastReadTs(OffsetDateTime lastReadTs) {
            this.lastReadTs = lastReadTs;
            return this;
        }

        @Override
        @JsonSetter(value="unread_count")
        public ExternalStage unreadCount(long unreadCount) {
            this.unreadCount = unreadCount;
            return this;
        }

        @Override
        @JsonSetter(value="external")
        public _FinalStage external(ThreadExternalLinks external) {
            this.external = external;
            return this;
        }

        @Override
        public _FinalStage tailMessage(Message tailMessage) {
            this.tailMessage = Optional.of(tailMessage);
            return this;
        }

        @Override
        @JsonSetter(value="tail_message", nulls=Nulls.SKIP)
        public _FinalStage tailMessage(Optional<Message> tailMessage) {
            this.tailMessage = tailMessage;
            return this;
        }

        @Override
        public Thread build() {
            return new Thread(this.threadId, this.createTs, this.topic, this.tailMessage, this.lastReadTs, this.unreadCount, this.external);
        }
    }

    public static interface _FinalStage {
        public Thread build();

        public _FinalStage tailMessage(Optional<Message> var1);

        public _FinalStage tailMessage(Message var1);
    }

    public static interface ExternalStage {
        public _FinalStage external(ThreadExternalLinks var1);
    }

    public static interface UnreadCountStage {
        public ExternalStage unreadCount(long var1);
    }

    public static interface LastReadTsStage {
        public UnreadCountStage lastReadTs(OffsetDateTime var1);
    }

    public static interface TopicStage {
        public LastReadTsStage topic(Topic var1);
    }

    public static interface CreateTsStage {
        public TopicStage createTs(OffsetDateTime var1);
    }

    public static interface ThreadIdStage {
        public CreateTsStage threadId(UUID var1);

        public Builder from(Thread var1);
    }
}

