/*
 * Decompiled with CFR 0.152.
 */
package com.rivet.api.resources.upload.common.types;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.rivet.api.core.ObjectMappers;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class PresignedRequest {
    private final String path;
    private final String url;

    private PresignedRequest(String path, String url) {
        this.path = path;
        this.url = url;
    }

    @JsonProperty(value="path")
    public String getPath() {
        return this.path;
    }

    @JsonProperty(value="url")
    public String getUrl() {
        return this.url;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof PresignedRequest && this.equalTo((PresignedRequest)other);
    }

    private boolean equalTo(PresignedRequest other) {
        return this.path.equals(other.path) && this.url.equals(other.url);
    }

    public int hashCode() {
        return Objects.hash(this.path, this.url);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static PathStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements PathStage,
    UrlStage,
    _FinalStage {
        private String path;
        private String url;

        private Builder() {
        }

        @Override
        public Builder from(PresignedRequest other) {
            this.path(other.getPath());
            this.url(other.getUrl());
            return this;
        }

        @Override
        @JsonSetter(value="path")
        public UrlStage path(String path) {
            this.path = path;
            return this;
        }

        @Override
        @JsonSetter(value="url")
        public _FinalStage url(String url) {
            this.url = url;
            return this;
        }

        @Override
        public PresignedRequest build() {
            return new PresignedRequest(this.path, this.url);
        }
    }

    public static interface _FinalStage {
        public PresignedRequest build();
    }

    public static interface UrlStage {
        public _FinalStage url(String var1);
    }

    public static interface PathStage {
        public UrlStage path(String var1);

        public Builder from(PresignedRequest var1);
    }
}

