/*
 * Decompiled with CFR 0.152.
 */
package com.rivet.api.resources.matchmaker.lobbies.types;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.rivet.api.core.ObjectMappers;
import com.rivet.api.resources.matchmaker.common.types.JoinLobby;
import com.rivet.api.resources.matchmaker.common.types.JoinPlayer;
import com.rivet.api.resources.matchmaker.common.types.JoinPort;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class CreateLobbyResponse {
    private final JoinLobby lobby;
    private final Map<String, JoinPort> ports;
    private final JoinPlayer player;

    private CreateLobbyResponse(JoinLobby lobby, Map<String, JoinPort> ports, JoinPlayer player) {
        this.lobby = lobby;
        this.ports = ports;
        this.player = player;
    }

    @JsonProperty(value="lobby")
    public JoinLobby getLobby() {
        return this.lobby;
    }

    @JsonProperty(value="ports")
    public Map<String, JoinPort> getPorts() {
        return this.ports;
    }

    @JsonProperty(value="player")
    public JoinPlayer getPlayer() {
        return this.player;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof CreateLobbyResponse && this.equalTo((CreateLobbyResponse)other);
    }

    private boolean equalTo(CreateLobbyResponse other) {
        return this.lobby.equals(other.lobby) && this.ports.equals(other.ports) && this.player.equals(other.player);
    }

    public int hashCode() {
        return Objects.hash(this.lobby, this.ports, this.player);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static LobbyStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements LobbyStage,
    PlayerStage,
    _FinalStage {
        private JoinLobby lobby;
        private JoinPlayer player;
        private Map<String, JoinPort> ports = new LinkedHashMap<String, JoinPort>();

        private Builder() {
        }

        @Override
        public Builder from(CreateLobbyResponse other) {
            this.lobby(other.getLobby());
            this.ports(other.getPorts());
            this.player(other.getPlayer());
            return this;
        }

        @Override
        @JsonSetter(value="lobby")
        public PlayerStage lobby(JoinLobby lobby) {
            this.lobby = lobby;
            return this;
        }

        @Override
        @JsonSetter(value="player")
        public _FinalStage player(JoinPlayer player) {
            this.player = player;
            return this;
        }

        @Override
        public _FinalStage ports(String key, JoinPort value) {
            this.ports.put(key, value);
            return this;
        }

        @Override
        public _FinalStage putAllPorts(Map<String, JoinPort> ports) {
            this.ports.putAll(ports);
            return this;
        }

        @Override
        @JsonSetter(value="ports", nulls=Nulls.SKIP)
        public _FinalStage ports(Map<String, JoinPort> ports) {
            this.ports.clear();
            this.ports.putAll(ports);
            return this;
        }

        @Override
        public CreateLobbyResponse build() {
            return new CreateLobbyResponse(this.lobby, this.ports, this.player);
        }
    }

    public static interface _FinalStage {
        public CreateLobbyResponse build();

        public _FinalStage ports(Map<String, JoinPort> var1);

        public _FinalStage putAllPorts(Map<String, JoinPort> var1);

        public _FinalStage ports(String var1, JoinPort var2);
    }

    public static interface PlayerStage {
        public _FinalStage player(JoinPlayer var1);
    }

    public static interface LobbyStage {
        public PlayerStage lobby(JoinLobby var1);

        public Builder from(CreateLobbyResponse var1);
    }
}

