/*
 * Decompiled with CFR 0.152.
 */
package com.rivet.api.resources.kv.types;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.rivet.api.core.ObjectMappers;
import com.rivet.api.resources.common.types.WatchResponse;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class GetResponse {
    private final Object value;
    private final Optional<Boolean> deleted;
    private final WatchResponse watch;

    private GetResponse(Object value, Optional<Boolean> deleted, WatchResponse watch) {
        this.value = value;
        this.deleted = deleted;
        this.watch = watch;
    }

    @JsonProperty(value="value")
    public Object getValue() {
        return this.value;
    }

    @JsonProperty(value="deleted")
    public Optional<Boolean> getDeleted() {
        return this.deleted;
    }

    @JsonProperty(value="watch")
    public WatchResponse getWatch() {
        return this.watch;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof GetResponse && this.equalTo((GetResponse)other);
    }

    private boolean equalTo(GetResponse other) {
        return this.value.equals(other.value) && this.deleted.equals(other.deleted) && this.watch.equals(other.watch);
    }

    public int hashCode() {
        return Objects.hash(this.value, this.deleted, this.watch);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static ValueStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements ValueStage,
    WatchStage,
    _FinalStage {
        private Object value;
        private WatchResponse watch;
        private Optional<Boolean> deleted = Optional.empty();

        private Builder() {
        }

        @Override
        public Builder from(GetResponse other) {
            this.value(other.getValue());
            this.deleted(other.getDeleted());
            this.watch(other.getWatch());
            return this;
        }

        @Override
        @JsonSetter(value="value")
        public WatchStage value(Object value) {
            this.value = value;
            return this;
        }

        @Override
        @JsonSetter(value="watch")
        public _FinalStage watch(WatchResponse watch) {
            this.watch = watch;
            return this;
        }

        @Override
        public _FinalStage deleted(Boolean deleted) {
            this.deleted = Optional.of(deleted);
            return this;
        }

        @Override
        @JsonSetter(value="deleted", nulls=Nulls.SKIP)
        public _FinalStage deleted(Optional<Boolean> deleted) {
            this.deleted = deleted;
            return this;
        }

        @Override
        public GetResponse build() {
            return new GetResponse(this.value, this.deleted, this.watch);
        }
    }

    public static interface _FinalStage {
        public GetResponse build();

        public _FinalStage deleted(Optional<Boolean> var1);

        public _FinalStage deleted(Boolean var1);
    }

    public static interface WatchStage {
        public _FinalStage watch(WatchResponse var1);
    }

    public static interface ValueStage {
        public WatchStage value(Object var1);

        public Builder from(GetResponse var1);
    }
}

