/*
 * Decompiled with CFR 0.152.
 */
package com.rivet.api.resources.identity.types;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.rivet.api.core.ObjectMappers;
import com.rivet.api.resources.common.types.WatchResponse;
import com.rivet.api.resources.identity.common.types.Handle;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class ListFollowingResponse {
    private final List<Handle> identities;
    private final Optional<String> anchor;
    private final WatchResponse watch;

    private ListFollowingResponse(List<Handle> identities, Optional<String> anchor, WatchResponse watch) {
        this.identities = identities;
        this.anchor = anchor;
        this.watch = watch;
    }

    @JsonProperty(value="identities")
    public List<Handle> getIdentities() {
        return this.identities;
    }

    @JsonProperty(value="anchor")
    public Optional<String> getAnchor() {
        return this.anchor;
    }

    @JsonProperty(value="watch")
    public WatchResponse getWatch() {
        return this.watch;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof ListFollowingResponse && this.equalTo((ListFollowingResponse)other);
    }

    private boolean equalTo(ListFollowingResponse other) {
        return this.identities.equals(other.identities) && this.anchor.equals(other.anchor) && this.watch.equals(other.watch);
    }

    public int hashCode() {
        return Objects.hash(this.identities, this.anchor, this.watch);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static WatchStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements WatchStage,
    _FinalStage {
        private WatchResponse watch;
        private Optional<String> anchor = Optional.empty();
        private List<Handle> identities = new ArrayList<Handle>();

        private Builder() {
        }

        @Override
        public Builder from(ListFollowingResponse other) {
            this.identities(other.getIdentities());
            this.anchor(other.getAnchor());
            this.watch(other.getWatch());
            return this;
        }

        @Override
        @JsonSetter(value="watch")
        public _FinalStage watch(WatchResponse watch) {
            this.watch = watch;
            return this;
        }

        @Override
        public _FinalStage anchor(String anchor) {
            this.anchor = Optional.of(anchor);
            return this;
        }

        @Override
        @JsonSetter(value="anchor", nulls=Nulls.SKIP)
        public _FinalStage anchor(Optional<String> anchor) {
            this.anchor = anchor;
            return this;
        }

        @Override
        public _FinalStage addAllIdentities(List<Handle> identities) {
            this.identities.addAll(identities);
            return this;
        }

        @Override
        public _FinalStage addIdentities(Handle identities) {
            this.identities.add(identities);
            return this;
        }

        @Override
        @JsonSetter(value="identities", nulls=Nulls.SKIP)
        public _FinalStage identities(List<Handle> identities) {
            this.identities.clear();
            this.identities.addAll(identities);
            return this;
        }

        @Override
        public ListFollowingResponse build() {
            return new ListFollowingResponse(this.identities, this.anchor, this.watch);
        }
    }

    public static interface _FinalStage {
        public ListFollowingResponse build();

        public _FinalStage identities(List<Handle> var1);

        public _FinalStage addIdentities(Handle var1);

        public _FinalStage addAllIdentities(List<Handle> var1);

        public _FinalStage anchor(Optional<String> var1);

        public _FinalStage anchor(String var1);
    }

    public static interface WatchStage {
        public _FinalStage watch(WatchResponse var1);

        public Builder from(ListFollowingResponse var1);
    }
}

