/*
 * Decompiled with CFR 0.152.
 */
package com.rivet.api.resources.identity.requests;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.rivet.api.core.ObjectMappers;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class ListFollowingRequest {
    private final Optional<String> anchor;
    private final Optional<String> limit;

    private ListFollowingRequest(Optional<String> anchor, Optional<String> limit) {
        this.anchor = anchor;
        this.limit = limit;
    }

    @JsonProperty(value="anchor")
    public Optional<String> getAnchor() {
        return this.anchor;
    }

    @JsonProperty(value="limit")
    public Optional<String> getLimit() {
        return this.limit;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof ListFollowingRequest && this.equalTo((ListFollowingRequest)other);
    }

    private boolean equalTo(ListFollowingRequest other) {
        return this.anchor.equals(other.anchor) && this.limit.equals(other.limit);
    }

    public int hashCode() {
        return Objects.hash(this.anchor, this.limit);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> anchor = Optional.empty();
        private Optional<String> limit = Optional.empty();

        private Builder() {
        }

        public Builder from(ListFollowingRequest other) {
            this.anchor(other.getAnchor());
            this.limit(other.getLimit());
            return this;
        }

        @JsonSetter(value="anchor", nulls=Nulls.SKIP)
        public Builder anchor(Optional<String> anchor) {
            this.anchor = anchor;
            return this;
        }

        public Builder anchor(String anchor) {
            this.anchor = Optional.of(anchor);
            return this;
        }

        @JsonSetter(value="limit", nulls=Nulls.SKIP)
        public Builder limit(Optional<String> limit) {
            this.limit = limit;
            return this;
        }

        public Builder limit(String limit) {
            this.limit = Optional.of(limit);
            return this;
        }

        public ListFollowingRequest build() {
            return new ListFollowingRequest(this.anchor, this.limit);
        }
    }
}

