/*
 * Decompiled with CFR 0.152.
 */
package com.rivet.api.resources.identity.links.types;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.rivet.api.core.ObjectMappers;
import java.time.OffsetDateTime;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class PrepareGameLinkResponse {
    private final String identityLinkToken;
    private final String identityLinkUrl;
    private final OffsetDateTime expireTs;

    private PrepareGameLinkResponse(String identityLinkToken, String identityLinkUrl, OffsetDateTime expireTs) {
        this.identityLinkToken = identityLinkToken;
        this.identityLinkUrl = identityLinkUrl;
        this.expireTs = expireTs;
    }

    @JsonProperty(value="identity_link_token")
    public String getIdentityLinkToken() {
        return this.identityLinkToken;
    }

    @JsonProperty(value="identity_link_url")
    public String getIdentityLinkUrl() {
        return this.identityLinkUrl;
    }

    @JsonProperty(value="expire_ts")
    public OffsetDateTime getExpireTs() {
        return this.expireTs;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof PrepareGameLinkResponse && this.equalTo((PrepareGameLinkResponse)other);
    }

    private boolean equalTo(PrepareGameLinkResponse other) {
        return this.identityLinkToken.equals(other.identityLinkToken) && this.identityLinkUrl.equals(other.identityLinkUrl) && this.expireTs.equals(other.expireTs);
    }

    public int hashCode() {
        return Objects.hash(this.identityLinkToken, this.identityLinkUrl, this.expireTs);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static IdentityLinkTokenStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements IdentityLinkTokenStage,
    IdentityLinkUrlStage,
    ExpireTsStage,
    _FinalStage {
        private String identityLinkToken;
        private String identityLinkUrl;
        private OffsetDateTime expireTs;

        private Builder() {
        }

        @Override
        public Builder from(PrepareGameLinkResponse other) {
            this.identityLinkToken(other.getIdentityLinkToken());
            this.identityLinkUrl(other.getIdentityLinkUrl());
            this.expireTs(other.getExpireTs());
            return this;
        }

        @Override
        @JsonSetter(value="identity_link_token")
        public IdentityLinkUrlStage identityLinkToken(String identityLinkToken) {
            this.identityLinkToken = identityLinkToken;
            return this;
        }

        @Override
        @JsonSetter(value="identity_link_url")
        public ExpireTsStage identityLinkUrl(String identityLinkUrl) {
            this.identityLinkUrl = identityLinkUrl;
            return this;
        }

        @Override
        @JsonSetter(value="expire_ts")
        public _FinalStage expireTs(OffsetDateTime expireTs) {
            this.expireTs = expireTs;
            return this;
        }

        @Override
        public PrepareGameLinkResponse build() {
            return new PrepareGameLinkResponse(this.identityLinkToken, this.identityLinkUrl, this.expireTs);
        }
    }

    public static interface _FinalStage {
        public PrepareGameLinkResponse build();
    }

    public static interface ExpireTsStage {
        public _FinalStage expireTs(OffsetDateTime var1);
    }

    public static interface IdentityLinkUrlStage {
        public ExpireTsStage identityLinkUrl(String var1);
    }

    public static interface IdentityLinkTokenStage {
        public IdentityLinkUrlStage identityLinkToken(String var1);

        public Builder from(PrepareGameLinkResponse var1);
    }
}

