/*
 * Decompiled with CFR 0.152.
 */
package com.rivet.api.resources.identity.events.types;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.rivet.api.core.ObjectMappers;
import com.rivet.api.resources.common.types.WatchResponse;
import com.rivet.api.resources.identity.common.types.GlobalEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class WatchEventsResponse {
    private final List<GlobalEvent> events;
    private final WatchResponse watch;

    private WatchEventsResponse(List<GlobalEvent> events, WatchResponse watch) {
        this.events = events;
        this.watch = watch;
    }

    @JsonProperty(value="events")
    public List<GlobalEvent> getEvents() {
        return this.events;
    }

    @JsonProperty(value="watch")
    public WatchResponse getWatch() {
        return this.watch;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof WatchEventsResponse && this.equalTo((WatchEventsResponse)other);
    }

    private boolean equalTo(WatchEventsResponse other) {
        return this.events.equals(other.events) && this.watch.equals(other.watch);
    }

    public int hashCode() {
        return Objects.hash(this.events, this.watch);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static WatchStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements WatchStage,
    _FinalStage {
        private WatchResponse watch;
        private List<GlobalEvent> events = new ArrayList<GlobalEvent>();

        private Builder() {
        }

        @Override
        public Builder from(WatchEventsResponse other) {
            this.events(other.getEvents());
            this.watch(other.getWatch());
            return this;
        }

        @Override
        @JsonSetter(value="watch")
        public _FinalStage watch(WatchResponse watch) {
            this.watch = watch;
            return this;
        }

        @Override
        public _FinalStage addAllEvents(List<GlobalEvent> events) {
            this.events.addAll(events);
            return this;
        }

        @Override
        public _FinalStage addEvents(GlobalEvent events) {
            this.events.add(events);
            return this;
        }

        @Override
        @JsonSetter(value="events", nulls=Nulls.SKIP)
        public _FinalStage events(List<GlobalEvent> events) {
            this.events.clear();
            this.events.addAll(events);
            return this;
        }

        @Override
        public WatchEventsResponse build() {
            return new WatchEventsResponse(this.events, this.watch);
        }
    }

    public static interface _FinalStage {
        public WatchEventsResponse build();

        public _FinalStage events(List<GlobalEvent> var1);

        public _FinalStage addEvents(GlobalEvent var1);

        public _FinalStage addAllEvents(List<GlobalEvent> var1);
    }

    public static interface WatchStage {
        public _FinalStage watch(WatchResponse var1);

        public Builder from(WatchEventsResponse var1);
    }
}

