/*
 * Decompiled with CFR 0.152.
 */
package com.rivet.api.resources.identity.common.types;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.rivet.api.core.ObjectMappers;
import com.rivet.api.resources.game.common.types.StatSummary;
import com.rivet.api.resources.identity.common.types.DevState;
import com.rivet.api.resources.identity.common.types.ExternalLinks;
import com.rivet.api.resources.identity.common.types.Group;
import com.rivet.api.resources.identity.common.types.LinkedAccount;
import com.rivet.api.resources.identity.common.types.Presence;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class Profile {
    private final UUID identityId;
    private final String displayName;
    private final int accountNumber;
    private final String avatarUrl;
    private final Optional<Presence> presence;
    private final boolean isRegistered;
    private final ExternalLinks external;
    private final boolean isAdmin;
    private final Optional<Boolean> isGameLinked;
    private final Optional<DevState> devState;
    private final long followerCount;
    private final long followingCount;
    private final boolean following;
    private final boolean isFollowingMe;
    private final boolean isMutualFollowing;
    private final OffsetDateTime joinTs;
    private final String bio;
    private final List<LinkedAccount> linkedAccounts;
    private final List<Group> groups;
    private final List<StatSummary> games;
    private final Optional<Boolean> awaitingDeletion;

    private Profile(UUID identityId, String displayName, int accountNumber, String avatarUrl, Optional<Presence> presence, boolean isRegistered, ExternalLinks external, boolean isAdmin, Optional<Boolean> isGameLinked, Optional<DevState> devState, long followerCount, long followingCount, boolean following, boolean isFollowingMe, boolean isMutualFollowing, OffsetDateTime joinTs, String bio, List<LinkedAccount> linkedAccounts, List<Group> groups, List<StatSummary> games, Optional<Boolean> awaitingDeletion) {
        this.identityId = identityId;
        this.displayName = displayName;
        this.accountNumber = accountNumber;
        this.avatarUrl = avatarUrl;
        this.presence = presence;
        this.isRegistered = isRegistered;
        this.external = external;
        this.isAdmin = isAdmin;
        this.isGameLinked = isGameLinked;
        this.devState = devState;
        this.followerCount = followerCount;
        this.followingCount = followingCount;
        this.following = following;
        this.isFollowingMe = isFollowingMe;
        this.isMutualFollowing = isMutualFollowing;
        this.joinTs = joinTs;
        this.bio = bio;
        this.linkedAccounts = linkedAccounts;
        this.groups = groups;
        this.games = games;
        this.awaitingDeletion = awaitingDeletion;
    }

    @JsonProperty(value="identity_id")
    public UUID getIdentityId() {
        return this.identityId;
    }

    @JsonProperty(value="display_name")
    public String getDisplayName() {
        return this.displayName;
    }

    @JsonProperty(value="account_number")
    public int getAccountNumber() {
        return this.accountNumber;
    }

    @JsonProperty(value="avatar_url")
    public String getAvatarUrl() {
        return this.avatarUrl;
    }

    @JsonProperty(value="presence")
    public Optional<Presence> getPresence() {
        return this.presence;
    }

    @JsonProperty(value="is_registered")
    public boolean getIsRegistered() {
        return this.isRegistered;
    }

    @JsonProperty(value="external")
    public ExternalLinks getExternal() {
        return this.external;
    }

    @JsonProperty(value="is_admin")
    public boolean getIsAdmin() {
        return this.isAdmin;
    }

    @JsonProperty(value="is_game_linked")
    public Optional<Boolean> getIsGameLinked() {
        return this.isGameLinked;
    }

    @JsonProperty(value="dev_state")
    public Optional<DevState> getDevState() {
        return this.devState;
    }

    @JsonProperty(value="follower_count")
    public long getFollowerCount() {
        return this.followerCount;
    }

    @JsonProperty(value="following_count")
    public long getFollowingCount() {
        return this.followingCount;
    }

    @JsonProperty(value="following")
    public boolean getFollowing() {
        return this.following;
    }

    @JsonProperty(value="is_following_me")
    public boolean getIsFollowingMe() {
        return this.isFollowingMe;
    }

    @JsonProperty(value="is_mutual_following")
    public boolean getIsMutualFollowing() {
        return this.isMutualFollowing;
    }

    @JsonProperty(value="join_ts")
    public OffsetDateTime getJoinTs() {
        return this.joinTs;
    }

    @JsonProperty(value="bio")
    public String getBio() {
        return this.bio;
    }

    @JsonProperty(value="linked_accounts")
    public List<LinkedAccount> getLinkedAccounts() {
        return this.linkedAccounts;
    }

    @JsonProperty(value="groups")
    public List<Group> getGroups() {
        return this.groups;
    }

    @JsonProperty(value="games")
    public List<StatSummary> getGames() {
        return this.games;
    }

    @JsonProperty(value="awaiting_deletion")
    public Optional<Boolean> getAwaitingDeletion() {
        return this.awaitingDeletion;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof Profile && this.equalTo((Profile)other);
    }

    private boolean equalTo(Profile other) {
        return this.identityId.equals(other.identityId) && this.displayName.equals(other.displayName) && this.accountNumber == other.accountNumber && this.avatarUrl.equals(other.avatarUrl) && this.presence.equals(other.presence) && this.isRegistered == other.isRegistered && this.external.equals(other.external) && this.isAdmin == other.isAdmin && this.isGameLinked.equals(other.isGameLinked) && this.devState.equals(other.devState) && this.followerCount == other.followerCount && this.followingCount == other.followingCount && this.following == other.following && this.isFollowingMe == other.isFollowingMe && this.isMutualFollowing == other.isMutualFollowing && this.joinTs.equals(other.joinTs) && this.bio.equals(other.bio) && this.linkedAccounts.equals(other.linkedAccounts) && this.groups.equals(other.groups) && this.games.equals(other.games) && this.awaitingDeletion.equals(other.awaitingDeletion);
    }

    public int hashCode() {
        return Objects.hash(this.identityId, this.displayName, this.accountNumber, this.avatarUrl, this.presence, this.isRegistered, this.external, this.isAdmin, this.isGameLinked, this.devState, this.followerCount, this.followingCount, this.following, this.isFollowingMe, this.isMutualFollowing, this.joinTs, this.bio, this.linkedAccounts, this.groups, this.games, this.awaitingDeletion);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static IdentityIdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements IdentityIdStage,
    DisplayNameStage,
    AccountNumberStage,
    AvatarUrlStage,
    IsRegisteredStage,
    ExternalStage,
    IsAdminStage,
    FollowerCountStage,
    FollowingCountStage,
    FollowingStage,
    IsFollowingMeStage,
    IsMutualFollowingStage,
    JoinTsStage,
    BioStage,
    _FinalStage {
        private UUID identityId;
        private String displayName;
        private int accountNumber;
        private String avatarUrl;
        private boolean isRegistered;
        private ExternalLinks external;
        private boolean isAdmin;
        private long followerCount;
        private long followingCount;
        private boolean following;
        private boolean isFollowingMe;
        private boolean isMutualFollowing;
        private OffsetDateTime joinTs;
        private String bio;
        private Optional<Boolean> awaitingDeletion = Optional.empty();
        private List<StatSummary> games = new ArrayList<StatSummary>();
        private List<Group> groups = new ArrayList<Group>();
        private List<LinkedAccount> linkedAccounts = new ArrayList<LinkedAccount>();
        private Optional<DevState> devState = Optional.empty();
        private Optional<Boolean> isGameLinked = Optional.empty();
        private Optional<Presence> presence = Optional.empty();

        private Builder() {
        }

        @Override
        public Builder from(Profile other) {
            this.identityId(other.getIdentityId());
            this.displayName(other.getDisplayName());
            this.accountNumber(other.getAccountNumber());
            this.avatarUrl(other.getAvatarUrl());
            this.presence(other.getPresence());
            this.isRegistered(other.getIsRegistered());
            this.external(other.getExternal());
            this.isAdmin(other.getIsAdmin());
            this.isGameLinked(other.getIsGameLinked());
            this.devState(other.getDevState());
            this.followerCount(other.getFollowerCount());
            this.followingCount(other.getFollowingCount());
            this.following(other.getFollowing());
            this.isFollowingMe(other.getIsFollowingMe());
            this.isMutualFollowing(other.getIsMutualFollowing());
            this.joinTs(other.getJoinTs());
            this.bio(other.getBio());
            this.linkedAccounts(other.getLinkedAccounts());
            this.groups(other.getGroups());
            this.games(other.getGames());
            this.awaitingDeletion(other.getAwaitingDeletion());
            return this;
        }

        @Override
        @JsonSetter(value="identity_id")
        public DisplayNameStage identityId(UUID identityId) {
            this.identityId = identityId;
            return this;
        }

        @Override
        @JsonSetter(value="display_name")
        public AccountNumberStage displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        @Override
        @JsonSetter(value="account_number")
        public AvatarUrlStage accountNumber(int accountNumber) {
            this.accountNumber = accountNumber;
            return this;
        }

        @Override
        @JsonSetter(value="avatar_url")
        public IsRegisteredStage avatarUrl(String avatarUrl) {
            this.avatarUrl = avatarUrl;
            return this;
        }

        @Override
        @JsonSetter(value="is_registered")
        public ExternalStage isRegistered(boolean isRegistered) {
            this.isRegistered = isRegistered;
            return this;
        }

        @Override
        @JsonSetter(value="external")
        public IsAdminStage external(ExternalLinks external) {
            this.external = external;
            return this;
        }

        @Override
        @JsonSetter(value="is_admin")
        public FollowerCountStage isAdmin(boolean isAdmin) {
            this.isAdmin = isAdmin;
            return this;
        }

        @Override
        @JsonSetter(value="follower_count")
        public FollowingCountStage followerCount(long followerCount) {
            this.followerCount = followerCount;
            return this;
        }

        @Override
        @JsonSetter(value="following_count")
        public FollowingStage followingCount(long followingCount) {
            this.followingCount = followingCount;
            return this;
        }

        @Override
        @JsonSetter(value="following")
        public IsFollowingMeStage following(boolean following) {
            this.following = following;
            return this;
        }

        @Override
        @JsonSetter(value="is_following_me")
        public IsMutualFollowingStage isFollowingMe(boolean isFollowingMe) {
            this.isFollowingMe = isFollowingMe;
            return this;
        }

        @Override
        @JsonSetter(value="is_mutual_following")
        public JoinTsStage isMutualFollowing(boolean isMutualFollowing) {
            this.isMutualFollowing = isMutualFollowing;
            return this;
        }

        @Override
        @JsonSetter(value="join_ts")
        public BioStage joinTs(OffsetDateTime joinTs) {
            this.joinTs = joinTs;
            return this;
        }

        @Override
        @JsonSetter(value="bio")
        public _FinalStage bio(String bio) {
            this.bio = bio;
            return this;
        }

        @Override
        public _FinalStage awaitingDeletion(Boolean awaitingDeletion) {
            this.awaitingDeletion = Optional.of(awaitingDeletion);
            return this;
        }

        @Override
        @JsonSetter(value="awaiting_deletion", nulls=Nulls.SKIP)
        public _FinalStage awaitingDeletion(Optional<Boolean> awaitingDeletion) {
            this.awaitingDeletion = awaitingDeletion;
            return this;
        }

        @Override
        public _FinalStage addAllGames(List<StatSummary> games) {
            this.games.addAll(games);
            return this;
        }

        @Override
        public _FinalStage addGames(StatSummary games) {
            this.games.add(games);
            return this;
        }

        @Override
        @JsonSetter(value="games", nulls=Nulls.SKIP)
        public _FinalStage games(List<StatSummary> games) {
            this.games.clear();
            this.games.addAll(games);
            return this;
        }

        @Override
        public _FinalStage addAllGroups(List<Group> groups) {
            this.groups.addAll(groups);
            return this;
        }

        @Override
        public _FinalStage addGroups(Group groups) {
            this.groups.add(groups);
            return this;
        }

        @Override
        @JsonSetter(value="groups", nulls=Nulls.SKIP)
        public _FinalStage groups(List<Group> groups) {
            this.groups.clear();
            this.groups.addAll(groups);
            return this;
        }

        @Override
        public _FinalStage addAllLinkedAccounts(List<LinkedAccount> linkedAccounts) {
            this.linkedAccounts.addAll(linkedAccounts);
            return this;
        }

        @Override
        public _FinalStage addLinkedAccounts(LinkedAccount linkedAccounts) {
            this.linkedAccounts.add(linkedAccounts);
            return this;
        }

        @Override
        @JsonSetter(value="linked_accounts", nulls=Nulls.SKIP)
        public _FinalStage linkedAccounts(List<LinkedAccount> linkedAccounts) {
            this.linkedAccounts.clear();
            this.linkedAccounts.addAll(linkedAccounts);
            return this;
        }

        @Override
        public _FinalStage devState(DevState devState) {
            this.devState = Optional.of(devState);
            return this;
        }

        @Override
        @JsonSetter(value="dev_state", nulls=Nulls.SKIP)
        public _FinalStage devState(Optional<DevState> devState) {
            this.devState = devState;
            return this;
        }

        @Override
        public _FinalStage isGameLinked(Boolean isGameLinked) {
            this.isGameLinked = Optional.of(isGameLinked);
            return this;
        }

        @Override
        @JsonSetter(value="is_game_linked", nulls=Nulls.SKIP)
        public _FinalStage isGameLinked(Optional<Boolean> isGameLinked) {
            this.isGameLinked = isGameLinked;
            return this;
        }

        @Override
        public _FinalStage presence(Presence presence) {
            this.presence = Optional.of(presence);
            return this;
        }

        @Override
        @JsonSetter(value="presence", nulls=Nulls.SKIP)
        public _FinalStage presence(Optional<Presence> presence) {
            this.presence = presence;
            return this;
        }

        @Override
        public Profile build() {
            return new Profile(this.identityId, this.displayName, this.accountNumber, this.avatarUrl, this.presence, this.isRegistered, this.external, this.isAdmin, this.isGameLinked, this.devState, this.followerCount, this.followingCount, this.following, this.isFollowingMe, this.isMutualFollowing, this.joinTs, this.bio, this.linkedAccounts, this.groups, this.games, this.awaitingDeletion);
        }
    }

    public static interface _FinalStage {
        public Profile build();

        public _FinalStage presence(Optional<Presence> var1);

        public _FinalStage presence(Presence var1);

        public _FinalStage isGameLinked(Optional<Boolean> var1);

        public _FinalStage isGameLinked(Boolean var1);

        public _FinalStage devState(Optional<DevState> var1);

        public _FinalStage devState(DevState var1);

        public _FinalStage linkedAccounts(List<LinkedAccount> var1);

        public _FinalStage addLinkedAccounts(LinkedAccount var1);

        public _FinalStage addAllLinkedAccounts(List<LinkedAccount> var1);

        public _FinalStage groups(List<Group> var1);

        public _FinalStage addGroups(Group var1);

        public _FinalStage addAllGroups(List<Group> var1);

        public _FinalStage games(List<StatSummary> var1);

        public _FinalStage addGames(StatSummary var1);

        public _FinalStage addAllGames(List<StatSummary> var1);

        public _FinalStage awaitingDeletion(Optional<Boolean> var1);

        public _FinalStage awaitingDeletion(Boolean var1);
    }

    public static interface BioStage {
        public _FinalStage bio(String var1);
    }

    public static interface JoinTsStage {
        public BioStage joinTs(OffsetDateTime var1);
    }

    public static interface IsMutualFollowingStage {
        public JoinTsStage isMutualFollowing(boolean var1);
    }

    public static interface IsFollowingMeStage {
        public IsMutualFollowingStage isFollowingMe(boolean var1);
    }

    public static interface FollowingStage {
        public IsFollowingMeStage following(boolean var1);
    }

    public static interface FollowingCountStage {
        public FollowingStage followingCount(long var1);
    }

    public static interface FollowerCountStage {
        public FollowingCountStage followerCount(long var1);
    }

    public static interface IsAdminStage {
        public FollowerCountStage isAdmin(boolean var1);
    }

    public static interface ExternalStage {
        public IsAdminStage external(ExternalLinks var1);
    }

    public static interface IsRegisteredStage {
        public ExternalStage isRegistered(boolean var1);
    }

    public static interface AvatarUrlStage {
        public IsRegisteredStage avatarUrl(String var1);
    }

    public static interface AccountNumberStage {
        public AvatarUrlStage accountNumber(int var1);
    }

    public static interface DisplayNameStage {
        public AccountNumberStage displayName(String var1);
    }

    public static interface IdentityIdStage {
        public DisplayNameStage identityId(UUID var1);

        public Builder from(Profile var1);
    }
}

