/*
 * Decompiled with CFR 0.152.
 */
package com.rivet.api.resources.identity.common.types;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.rivet.api.core.ObjectMappers;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class GlobalEventNotification {
    private final String title;
    private final String description;
    private final String thumbnailUrl;
    private final String url;

    private GlobalEventNotification(String title, String description, String thumbnailUrl, String url) {
        this.title = title;
        this.description = description;
        this.thumbnailUrl = thumbnailUrl;
        this.url = url;
    }

    @JsonProperty(value="title")
    public String getTitle() {
        return this.title;
    }

    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="thumbnail_url")
    public String getThumbnailUrl() {
        return this.thumbnailUrl;
    }

    @JsonProperty(value="url")
    public String getUrl() {
        return this.url;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof GlobalEventNotification && this.equalTo((GlobalEventNotification)other);
    }

    private boolean equalTo(GlobalEventNotification other) {
        return this.title.equals(other.title) && this.description.equals(other.description) && this.thumbnailUrl.equals(other.thumbnailUrl) && this.url.equals(other.url);
    }

    public int hashCode() {
        return Objects.hash(this.title, this.description, this.thumbnailUrl, this.url);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static TitleStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements TitleStage,
    DescriptionStage,
    ThumbnailUrlStage,
    UrlStage,
    _FinalStage {
        private String title;
        private String description;
        private String thumbnailUrl;
        private String url;

        private Builder() {
        }

        @Override
        public Builder from(GlobalEventNotification other) {
            this.title(other.getTitle());
            this.description(other.getDescription());
            this.thumbnailUrl(other.getThumbnailUrl());
            this.url(other.getUrl());
            return this;
        }

        @Override
        @JsonSetter(value="title")
        public DescriptionStage title(String title) {
            this.title = title;
            return this;
        }

        @Override
        @JsonSetter(value="description")
        public ThumbnailUrlStage description(String description) {
            this.description = description;
            return this;
        }

        @Override
        @JsonSetter(value="thumbnail_url")
        public UrlStage thumbnailUrl(String thumbnailUrl) {
            this.thumbnailUrl = thumbnailUrl;
            return this;
        }

        @Override
        @JsonSetter(value="url")
        public _FinalStage url(String url) {
            this.url = url;
            return this;
        }

        @Override
        public GlobalEventNotification build() {
            return new GlobalEventNotification(this.title, this.description, this.thumbnailUrl, this.url);
        }
    }

    public static interface _FinalStage {
        public GlobalEventNotification build();
    }

    public static interface UrlStage {
        public _FinalStage url(String var1);
    }

    public static interface ThumbnailUrlStage {
        public UrlStage thumbnailUrl(String var1);
    }

    public static interface DescriptionStage {
        public ThumbnailUrlStage description(String var1);
    }

    public static interface TitleStage {
        public DescriptionStage title(String var1);

        public Builder from(GlobalEventNotification var1);
    }
}

