/*
 * Decompiled with CFR 0.152.
 */
package com.rivet.api.resources.identity.common.types;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.rivet.api.core.ObjectMappers;
import com.rivet.api.resources.game.common.types.Handle;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class GameActivity {
    private final Handle game;
    private final String message;
    private final Optional<Object> publicMetadata;
    private final Optional<Object> mutualMetadata;

    private GameActivity(Handle game, String message, Optional<Object> publicMetadata, Optional<Object> mutualMetadata) {
        this.game = game;
        this.message = message;
        this.publicMetadata = publicMetadata;
        this.mutualMetadata = mutualMetadata;
    }

    @JsonProperty(value="game")
    public Handle getGame() {
        return this.game;
    }

    @JsonProperty(value="message")
    public String getMessage() {
        return this.message;
    }

    @JsonProperty(value="public_metadata")
    public Optional<Object> getPublicMetadata() {
        return this.publicMetadata;
    }

    @JsonProperty(value="mutual_metadata")
    public Optional<Object> getMutualMetadata() {
        return this.mutualMetadata;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof GameActivity && this.equalTo((GameActivity)other);
    }

    private boolean equalTo(GameActivity other) {
        return this.game.equals(other.game) && this.message.equals(other.message) && this.publicMetadata.equals(other.publicMetadata) && this.mutualMetadata.equals(other.mutualMetadata);
    }

    public int hashCode() {
        return Objects.hash(this.game, this.message, this.publicMetadata, this.mutualMetadata);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static GameStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements GameStage,
    MessageStage,
    _FinalStage {
        private Handle game;
        private String message;
        private Optional<Object> mutualMetadata = Optional.empty();
        private Optional<Object> publicMetadata = Optional.empty();

        private Builder() {
        }

        @Override
        public Builder from(GameActivity other) {
            this.game(other.getGame());
            this.message(other.getMessage());
            this.publicMetadata(other.getPublicMetadata());
            this.mutualMetadata(other.getMutualMetadata());
            return this;
        }

        @Override
        @JsonSetter(value="game")
        public MessageStage game(Handle game) {
            this.game = game;
            return this;
        }

        @Override
        @JsonSetter(value="message")
        public _FinalStage message(String message) {
            this.message = message;
            return this;
        }

        @Override
        public _FinalStage mutualMetadata(Object mutualMetadata) {
            this.mutualMetadata = Optional.of(mutualMetadata);
            return this;
        }

        @Override
        @JsonSetter(value="mutual_metadata", nulls=Nulls.SKIP)
        public _FinalStage mutualMetadata(Optional<Object> mutualMetadata) {
            this.mutualMetadata = mutualMetadata;
            return this;
        }

        @Override
        public _FinalStage publicMetadata(Object publicMetadata) {
            this.publicMetadata = Optional.of(publicMetadata);
            return this;
        }

        @Override
        @JsonSetter(value="public_metadata", nulls=Nulls.SKIP)
        public _FinalStage publicMetadata(Optional<Object> publicMetadata) {
            this.publicMetadata = publicMetadata;
            return this;
        }

        @Override
        public GameActivity build() {
            return new GameActivity(this.game, this.message, this.publicMetadata, this.mutualMetadata);
        }
    }

    public static interface _FinalStage {
        public GameActivity build();

        public _FinalStage publicMetadata(Optional<Object> var1);

        public _FinalStage publicMetadata(Object var1);

        public _FinalStage mutualMetadata(Optional<Object> var1);

        public _FinalStage mutualMetadata(Object var1);
    }

    public static interface MessageStage {
        public _FinalStage message(String var1);
    }

    public static interface GameStage {
        public MessageStage game(Handle var1);

        public Builder from(GameActivity var1);
    }
}

