/*
 * Decompiled with CFR 0.152.
 */
package com.rivet.api.resources.group.types;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.rivet.api.core.ObjectMappers;
import com.rivet.api.resources.common.types.WatchResponse;
import com.rivet.api.resources.group.common.types.BannedIdentity;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class GetBansResponse {
    private final List<BannedIdentity> bannedIdentities;
    private final Optional<String> anchor;
    private final WatchResponse watch;

    private GetBansResponse(List<BannedIdentity> bannedIdentities, Optional<String> anchor, WatchResponse watch) {
        this.bannedIdentities = bannedIdentities;
        this.anchor = anchor;
        this.watch = watch;
    }

    @JsonProperty(value="banned_identities")
    public List<BannedIdentity> getBannedIdentities() {
        return this.bannedIdentities;
    }

    @JsonProperty(value="anchor")
    public Optional<String> getAnchor() {
        return this.anchor;
    }

    @JsonProperty(value="watch")
    public WatchResponse getWatch() {
        return this.watch;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof GetBansResponse && this.equalTo((GetBansResponse)other);
    }

    private boolean equalTo(GetBansResponse other) {
        return this.bannedIdentities.equals(other.bannedIdentities) && this.anchor.equals(other.anchor) && this.watch.equals(other.watch);
    }

    public int hashCode() {
        return Objects.hash(this.bannedIdentities, this.anchor, this.watch);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static WatchStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements WatchStage,
    _FinalStage {
        private WatchResponse watch;
        private Optional<String> anchor = Optional.empty();
        private List<BannedIdentity> bannedIdentities = new ArrayList<BannedIdentity>();

        private Builder() {
        }

        @Override
        public Builder from(GetBansResponse other) {
            this.bannedIdentities(other.getBannedIdentities());
            this.anchor(other.getAnchor());
            this.watch(other.getWatch());
            return this;
        }

        @Override
        @JsonSetter(value="watch")
        public _FinalStage watch(WatchResponse watch) {
            this.watch = watch;
            return this;
        }

        @Override
        public _FinalStage anchor(String anchor) {
            this.anchor = Optional.of(anchor);
            return this;
        }

        @Override
        @JsonSetter(value="anchor", nulls=Nulls.SKIP)
        public _FinalStage anchor(Optional<String> anchor) {
            this.anchor = anchor;
            return this;
        }

        @Override
        public _FinalStage addAllBannedIdentities(List<BannedIdentity> bannedIdentities) {
            this.bannedIdentities.addAll(bannedIdentities);
            return this;
        }

        @Override
        public _FinalStage addBannedIdentities(BannedIdentity bannedIdentities) {
            this.bannedIdentities.add(bannedIdentities);
            return this;
        }

        @Override
        @JsonSetter(value="banned_identities", nulls=Nulls.SKIP)
        public _FinalStage bannedIdentities(List<BannedIdentity> bannedIdentities) {
            this.bannedIdentities.clear();
            this.bannedIdentities.addAll(bannedIdentities);
            return this;
        }

        @Override
        public GetBansResponse build() {
            return new GetBansResponse(this.bannedIdentities, this.anchor, this.watch);
        }
    }

    public static interface _FinalStage {
        public GetBansResponse build();

        public _FinalStage bannedIdentities(List<BannedIdentity> var1);

        public _FinalStage addBannedIdentities(BannedIdentity var1);

        public _FinalStage addAllBannedIdentities(List<BannedIdentity> var1);

        public _FinalStage anchor(Optional<String> var1);

        public _FinalStage anchor(String var1);
    }

    public static interface WatchStage {
        public _FinalStage watch(WatchResponse var1);

        public Builder from(GetBansResponse var1);
    }
}

