/*
 * Decompiled with CFR 0.152.
 */
package com.rivet.api.resources.group.requests;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.rivet.api.core.ObjectMappers;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class GetMembersRequest {
    private final Optional<String> anchor;
    private final Optional<Double> count;
    private final Optional<String> watchIndex;

    private GetMembersRequest(Optional<String> anchor, Optional<Double> count, Optional<String> watchIndex) {
        this.anchor = anchor;
        this.count = count;
        this.watchIndex = watchIndex;
    }

    @JsonProperty(value="anchor")
    public Optional<String> getAnchor() {
        return this.anchor;
    }

    @JsonProperty(value="count")
    public Optional<Double> getCount() {
        return this.count;
    }

    @JsonProperty(value="watch_index")
    public Optional<String> getWatchIndex() {
        return this.watchIndex;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof GetMembersRequest && this.equalTo((GetMembersRequest)other);
    }

    private boolean equalTo(GetMembersRequest other) {
        return this.anchor.equals(other.anchor) && this.count.equals(other.count) && this.watchIndex.equals(other.watchIndex);
    }

    public int hashCode() {
        return Objects.hash(this.anchor, this.count, this.watchIndex);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> anchor = Optional.empty();
        private Optional<Double> count = Optional.empty();
        private Optional<String> watchIndex = Optional.empty();

        private Builder() {
        }

        public Builder from(GetMembersRequest other) {
            this.anchor(other.getAnchor());
            this.count(other.getCount());
            this.watchIndex(other.getWatchIndex());
            return this;
        }

        @JsonSetter(value="anchor", nulls=Nulls.SKIP)
        public Builder anchor(Optional<String> anchor) {
            this.anchor = anchor;
            return this;
        }

        public Builder anchor(String anchor) {
            this.anchor = Optional.of(anchor);
            return this;
        }

        @JsonSetter(value="count", nulls=Nulls.SKIP)
        public Builder count(Optional<Double> count) {
            this.count = count;
            return this;
        }

        public Builder count(Double count) {
            this.count = Optional.of(count);
            return this;
        }

        @JsonSetter(value="watch_index", nulls=Nulls.SKIP)
        public Builder watchIndex(Optional<String> watchIndex) {
            this.watchIndex = watchIndex;
            return this;
        }

        public Builder watchIndex(String watchIndex) {
            this.watchIndex = Optional.of(watchIndex);
            return this;
        }

        public GetMembersRequest build() {
            return new GetMembersRequest(this.anchor, this.count, this.watchIndex);
        }
    }
}

