/*
 * Decompiled with CFR 0.152.
 */
package com.rivet.api.resources.group.common.types;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.rivet.api.core.ObjectMappers;
import com.rivet.api.resources.group.common.types.ExternalLinks;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class Handle {
    private final UUID groupId;
    private final String displayName;
    private final Optional<String> avatarUrl;
    private final ExternalLinks external;
    private final Optional<Boolean> isDeveloper;

    private Handle(UUID groupId, String displayName, Optional<String> avatarUrl, ExternalLinks external, Optional<Boolean> isDeveloper) {
        this.groupId = groupId;
        this.displayName = displayName;
        this.avatarUrl = avatarUrl;
        this.external = external;
        this.isDeveloper = isDeveloper;
    }

    @JsonProperty(value="group_id")
    public UUID getGroupId() {
        return this.groupId;
    }

    @JsonProperty(value="display_name")
    public String getDisplayName() {
        return this.displayName;
    }

    @JsonProperty(value="avatar_url")
    public Optional<String> getAvatarUrl() {
        return this.avatarUrl;
    }

    @JsonProperty(value="external")
    public ExternalLinks getExternal() {
        return this.external;
    }

    @JsonProperty(value="is_developer")
    public Optional<Boolean> getIsDeveloper() {
        return this.isDeveloper;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof Handle && this.equalTo((Handle)other);
    }

    private boolean equalTo(Handle other) {
        return this.groupId.equals(other.groupId) && this.displayName.equals(other.displayName) && this.avatarUrl.equals(other.avatarUrl) && this.external.equals(other.external) && this.isDeveloper.equals(other.isDeveloper);
    }

    public int hashCode() {
        return Objects.hash(this.groupId, this.displayName, this.avatarUrl, this.external, this.isDeveloper);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static GroupIdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements GroupIdStage,
    DisplayNameStage,
    ExternalStage,
    _FinalStage {
        private UUID groupId;
        private String displayName;
        private ExternalLinks external;
        private Optional<Boolean> isDeveloper = Optional.empty();
        private Optional<String> avatarUrl = Optional.empty();

        private Builder() {
        }

        @Override
        public Builder from(Handle other) {
            this.groupId(other.getGroupId());
            this.displayName(other.getDisplayName());
            this.avatarUrl(other.getAvatarUrl());
            this.external(other.getExternal());
            this.isDeveloper(other.getIsDeveloper());
            return this;
        }

        @Override
        @JsonSetter(value="group_id")
        public DisplayNameStage groupId(UUID groupId) {
            this.groupId = groupId;
            return this;
        }

        @Override
        @JsonSetter(value="display_name")
        public ExternalStage displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        @Override
        @JsonSetter(value="external")
        public _FinalStage external(ExternalLinks external) {
            this.external = external;
            return this;
        }

        @Override
        public _FinalStage isDeveloper(Boolean isDeveloper) {
            this.isDeveloper = Optional.of(isDeveloper);
            return this;
        }

        @Override
        @JsonSetter(value="is_developer", nulls=Nulls.SKIP)
        public _FinalStage isDeveloper(Optional<Boolean> isDeveloper) {
            this.isDeveloper = isDeveloper;
            return this;
        }

        @Override
        public _FinalStage avatarUrl(String avatarUrl) {
            this.avatarUrl = Optional.of(avatarUrl);
            return this;
        }

        @Override
        @JsonSetter(value="avatar_url", nulls=Nulls.SKIP)
        public _FinalStage avatarUrl(Optional<String> avatarUrl) {
            this.avatarUrl = avatarUrl;
            return this;
        }

        @Override
        public Handle build() {
            return new Handle(this.groupId, this.displayName, this.avatarUrl, this.external, this.isDeveloper);
        }
    }

    public static interface _FinalStage {
        public Handle build();

        public _FinalStage avatarUrl(Optional<String> var1);

        public _FinalStage avatarUrl(String var1);

        public _FinalStage isDeveloper(Optional<Boolean> var1);

        public _FinalStage isDeveloper(Boolean var1);
    }

    public static interface ExternalStage {
        public _FinalStage external(ExternalLinks var1);
    }

    public static interface DisplayNameStage {
        public ExternalStage displayName(String var1);
    }

    public static interface GroupIdStage {
        public DisplayNameStage groupId(UUID var1);

        public Builder from(Handle var1);
    }
}

