/*
 * Decompiled with CFR 0.152.
 */
package com.rivet.api.resources.game.common.types;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.rivet.api.core.ObjectMappers;
import com.rivet.api.resources.game.common.types.StatConfig;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class Stat {
    private final StatConfig config;
    private final double overallValue;

    private Stat(StatConfig config, double overallValue) {
        this.config = config;
        this.overallValue = overallValue;
    }

    @JsonProperty(value="config")
    public StatConfig getConfig() {
        return this.config;
    }

    @JsonProperty(value="overall_value")
    public double getOverallValue() {
        return this.overallValue;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof Stat && this.equalTo((Stat)other);
    }

    private boolean equalTo(Stat other) {
        return this.config.equals(other.config) && this.overallValue == other.overallValue;
    }

    public int hashCode() {
        return Objects.hash(this.config, this.overallValue);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static ConfigStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements ConfigStage,
    OverallValueStage,
    _FinalStage {
        private StatConfig config;
        private double overallValue;

        private Builder() {
        }

        @Override
        public Builder from(Stat other) {
            this.config(other.getConfig());
            this.overallValue(other.getOverallValue());
            return this;
        }

        @Override
        @JsonSetter(value="config")
        public OverallValueStage config(StatConfig config) {
            this.config = config;
            return this;
        }

        @Override
        @JsonSetter(value="overall_value")
        public _FinalStage overallValue(double overallValue) {
            this.overallValue = overallValue;
            return this;
        }

        @Override
        public Stat build() {
            return new Stat(this.config, this.overallValue);
        }
    }

    public static interface _FinalStage {
        public Stat build();
    }

    public static interface OverallValueStage {
        public _FinalStage overallValue(double var1);
    }

    public static interface ConfigStage {
        public OverallValueStage config(StatConfig var1);

        public Builder from(Stat var1);
    }
}

