/*
 * Decompiled with CFR 0.152.
 */
package com.rivet.api.resources.cloud.version.matchmaker.lobbygroup.types;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.rivet.api.core.ObjectMappers;
import com.rivet.api.resources.cloud.version.matchmaker.lobbygroup.types.LobbyGroupIdleLobbiesConfig;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class LobbyGroupRegion {
    private final UUID regionId;
    private final String tierNameId;
    private final Optional<LobbyGroupIdleLobbiesConfig> idleLobbies;

    private LobbyGroupRegion(UUID regionId, String tierNameId, Optional<LobbyGroupIdleLobbiesConfig> idleLobbies) {
        this.regionId = regionId;
        this.tierNameId = tierNameId;
        this.idleLobbies = idleLobbies;
    }

    @JsonProperty(value="region_id")
    public UUID getRegionId() {
        return this.regionId;
    }

    @JsonProperty(value="tier_name_id")
    public String getTierNameId() {
        return this.tierNameId;
    }

    @JsonProperty(value="idle_lobbies")
    public Optional<LobbyGroupIdleLobbiesConfig> getIdleLobbies() {
        return this.idleLobbies;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof LobbyGroupRegion && this.equalTo((LobbyGroupRegion)other);
    }

    private boolean equalTo(LobbyGroupRegion other) {
        return this.regionId.equals(other.regionId) && this.tierNameId.equals(other.tierNameId) && this.idleLobbies.equals(other.idleLobbies);
    }

    public int hashCode() {
        return Objects.hash(this.regionId, this.tierNameId, this.idleLobbies);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static RegionIdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements RegionIdStage,
    TierNameIdStage,
    _FinalStage {
        private UUID regionId;
        private String tierNameId;
        private Optional<LobbyGroupIdleLobbiesConfig> idleLobbies = Optional.empty();

        private Builder() {
        }

        @Override
        public Builder from(LobbyGroupRegion other) {
            this.regionId(other.getRegionId());
            this.tierNameId(other.getTierNameId());
            this.idleLobbies(other.getIdleLobbies());
            return this;
        }

        @Override
        @JsonSetter(value="region_id")
        public TierNameIdStage regionId(UUID regionId) {
            this.regionId = regionId;
            return this;
        }

        @Override
        @JsonSetter(value="tier_name_id")
        public _FinalStage tierNameId(String tierNameId) {
            this.tierNameId = tierNameId;
            return this;
        }

        @Override
        public _FinalStage idleLobbies(LobbyGroupIdleLobbiesConfig idleLobbies) {
            this.idleLobbies = Optional.of(idleLobbies);
            return this;
        }

        @Override
        @JsonSetter(value="idle_lobbies", nulls=Nulls.SKIP)
        public _FinalStage idleLobbies(Optional<LobbyGroupIdleLobbiesConfig> idleLobbies) {
            this.idleLobbies = idleLobbies;
            return this;
        }

        @Override
        public LobbyGroupRegion build() {
            return new LobbyGroupRegion(this.regionId, this.tierNameId, this.idleLobbies);
        }
    }

    public static interface _FinalStage {
        public LobbyGroupRegion build();

        public _FinalStage idleLobbies(Optional<LobbyGroupIdleLobbiesConfig> var1);

        public _FinalStage idleLobbies(LobbyGroupIdleLobbiesConfig var1);
    }

    public static interface TierNameIdStage {
        public _FinalStage tierNameId(String var1);
    }

    public static interface RegionIdStage {
        public TierNameIdStage regionId(UUID var1);

        public Builder from(LobbyGroupRegion var1);
    }
}

